package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TYehuaqiUser;
import com.zehong.system.domain.vo.TDetectorUserVO;
import com.zehong.system.domain.vo.TYehuaqiUserVO;
import org.apache.ibatis.annotations.Param;

/**
 * 燃气用户Mapper接口
 * 
 * @author zehong
 * @date 2022-09-14
 */
public interface TYehuaqiUserMapper 
{
    /**
     * 查询燃气用户
     * 
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    public TYehuaqiUser selectTYehuaqiUserById(Long userId);

    /**
     * 根据 企业id 和 用户自有id 查询数据
     * @param beyondEnterpriseId b
     * @param userOwnId u
     * @return r
     */
    public TYehuaqiUser selectByUserOwnIdAndBeyondEnterpriseId(@Param("beyondEnterpriseId") String beyondEnterpriseId,
                                                               @Param("userOwnId") String userOwnId);

    /**
     * 根据 用户名称，电话，地址查询数据
     * @param nickName u
     * @param phone p
     * @param address a
     * @return r
     */
    public List<TYehuaqiUser> selectByUsernameAndPhoneAndAddress(@Param("nickName") String nickName,
                                                                 @Param("phone") String phone,
                                                                 @Param("address") String address);

    /**
     * 查询燃气用户列表
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TYehuaqiUser> selectTYehuaqiUserList(TYehuaqiUser tYehuaqiUser);

    /**
     * 根据 userOwnId list 和 enterpriseId 查询数据
     * @param userOwnIds userOwnId list
     * @param enterpriseId enterpriseId
     * @return r
     */
    public List<TYehuaqiUser> queryByUserOwnIdAndEnterpriseIdForThirdParty(@Param("userOwnIds") List<String> userOwnIds,@Param("enterpriseId") String enterpriseId);
    public List<TYehuaqiUser> selectTYehuaqiUserListTwo(TYehuaqiUser tYehuaqiUser);


    /**
     * 根据企业id 统计错误数量
     * @param beyondEnterpriseId id
     * @return r
     */
    public int countByBeyondEnterpriseId(String beyondEnterpriseId);

    /**
     * 新增燃气用户
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 结果
     */
    public int insertTYehuaqiUser(TYehuaqiUser tYehuaqiUser);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TYehuaqiUser> list);


    /**
     * 提供给第三方接口调用时的批量插入
     * @param tYehuaqiUsers r
     * @return r
     */
    public int insertBatchForThirdParty(List<TYehuaqiUser> tYehuaqiUsers);
    /**
     * 查询燃气用户列表 - 导出使用
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TYehuaqiUser> selectForExportTYehuaqiUserList(TYehuaqiUser tDetectorUser);

    /**
     * 根据userOwnIds 和  enterpriseId 查询数据
     * @param userOwnIds u
     * @param enterpriseId e
     * @return r
     */
    public List<TYehuaqiUser> queryByUserOwnIdsAndEnterpriseId(@Param("userOwnIds") List<String> userOwnIds,@Param("enterpriseId") String enterpriseId);

    public List<TYehuaqiUser> queryErrorDetectorUserList(String depId);
    /**
     * 修改燃气用户
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 结果
     */
    public int updateTYehuaqiUser(TYehuaqiUser tYehuaqiUser);

    /**批量修改
     * @param list list
     * @return r
     */
    public int updateBatch(@Param("list") List<TYehuaqiUser> list);

    /**
     * 删除燃气用户
     * 
     * @param userId 燃气用户ID
     * @return 结果
     */
    public int deleteTYehuaqiUserById(Long userId);

    /**
     * 批量删除燃气用户
     * 
     * @param userIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTYehuaqiUserByIds(Long[] userIds);

}
