package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TVillageLevelRegion;

/**
 * 村级行政区Mapper接口
 * 
 * @author zehong
 * @date 2024-06-07
 */
public interface TVillageLevelRegionMapper 
{
    /**
     * 查询村级行政区
     * 
     * @param fId 村级行政区ID
     * @return 村级行政区
     */
    public TVillageLevelRegion selectTVillageLevelRegionById(Long fId);

    /**
     * 查询村级行政区列表
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 村级行政区集合
     */
    public List<TVillageLevelRegion> selectTVillageLevelRegionList(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 新增村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    public int insertTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 修改村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    public int updateTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 删除村级行政区
     * 
     * @param fId 村级行政区ID
     * @return 结果
     */
    public int deleteTVillageLevelRegionById(Long fId);

    /**
     * 批量删除村级行政区
     * 
     * @param fIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTVillageLevelRegionByIds(Long[] fIds);

    /**
     * 批量新增
     * @param list 批量数据
     * @return
     */
    int batchInsertTVillageLevelRegion(List<TVillageLevelRegion> list);
}
