package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSecurityDisseminate;

/**
 * 安全宣传Mapper接口
 * 
 * @author zehong
 * @date 2024-04-22
 */
public interface TSecurityDisseminateMapper 
{
    /**
     * 查询安全宣传
     * 
     * @param securityId 安全宣传ID
     * @return 安全宣传
     */
    public TSecurityDisseminate selectTSecurityDisseminateById(Long securityId);

    /**
     * 查询安全宣传列表
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 安全宣传集合
     */
    public List<TSecurityDisseminate> selectTSecurityDisseminateList(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 新增安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    public int insertTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 修改安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    public int updateTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate);

    /**
     * 删除安全宣传
     * 
     * @param securityId 安全宣传ID
     * @return 结果
     */
    public int deleteTSecurityDisseminateById(Long securityId);

    /**
     * 批量删除安全宣传
     * 
     * @param securityIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSecurityDisseminateByIds(Long[] securityIds);
}
