package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;
import com.zehong.system.domain.TRiskDevMajInfor;
import org.apache.ibatis.annotations.Param;

/**
 * 重要风险点管控Mapper接口
 * 
 * @author zehong
 * @date 2024-07-01
 */
public interface TRiskDevMajInforMapper 
{
    /**
     * 查询重要风险点管控
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 重要风险点管控
     */
    public TRiskDevMajInfor selectTRiskDevMajInforById(Long fRiskDevMajInforId);


    /**
     * 查询重要风险点管控
     *
     * @param fRiskDevMajInforId 重要风险点管控ID - 详情用
     * @return 重要风险点管控
     */
    public TRiskDevMajInfor selectTRiskDevMajInforByIdForDetail(Long fRiskDevMajInforId);

    /**
     * 企业端上传数据
     * @return
     */
    public int entReportRiskDevMajInfor(@Param("state")  String state, @Param("entUploadTime") Date entUploadTime,
                                           @Param("fRiskDevMajInforId") Long fRiskDevMajInforId);
    /**
     * 查询重要风险点管控列表
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 重要风险点管控集合
     */
    public List<TRiskDevMajInfor> selectTRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 查询重要风险点管控列表 - 导出
     *
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 重要风险点管控集合
     */
    public List<TRiskDevMajInfor> exportRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 新增重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    public int insertTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 修改重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    public int updateTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor);

    /**
     * 删除重要风险点管控
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 结果
     */
    public int deleteTRiskDevMajInforById(Long fRiskDevMajInforId);

    /**
     * 批量删除重要风险点管控
     * 
     * @param fRiskDevMajInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTRiskDevMajInforByIds(Long[] fRiskDevMajInforIds);
}
