package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TMessageInfo;

/**
 * 消息Mapper接口
 * 
 * @author zehong
 * @date 2023-09-14
 */
public interface TMessageInfoMapper 
{
    /**
     * 查询消息
     * 
     * @param messageId 消息ID
     * @return 消息
     */
    public TMessageInfo selectTMessageInfoById(Long messageId);

    /**
     * 查询消息列表
     * 
     * @param tMessageInfo 消息
     * @return 消息集合
     */
    public List<TMessageInfo> selectTMessageInfoList(TMessageInfo tMessageInfo);
    public List<TMessageInfo> selectTMessageInfoListapp(TMessageInfo tMessageInfo);

    /**
     * 新增消息
     * 
     * @param tMessageInfo 消息
     * @return 结果
     */
    public int insertTMessageInfo(TMessageInfo tMessageInfo);

    /**
     * 修改消息
     * 
     * @param tMessageInfo 消息
     * @return 结果
     */
    public int updateTMessageInfo(TMessageInfo tMessageInfo);

    /**
     * 删除消息
     * 
     * @param messageId 消息ID
     * @return 结果
     */
    public int deleteTMessageInfoById(Long messageId);

    /**
     * 批量删除消息
     * 
     * @param messageIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTMessageInfoByIds(Long[] messageIds);
}
