package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLpgThirdPartyDockingInterfaceRecord;
import org.apache.ibatis.annotations.Param;

/**
 * 液化气第三方对接接口记录Mapper接口
 * 
 * @author zehong
 * @date 2024-09-18
 */
public interface TLpgThirdPartyDockingInterfaceRecordMapper 
{
    /**
     * 查询液化气第三方对接接口记录
     * 
     * @param recordId 液化气第三方对接接口记录ID
     * @return 液化气第三方对接接口记录
     */
    public TLpgThirdPartyDockingInterfaceRecord selectTLpgThirdPartyDockingInterfaceRecordById(Long recordId);

    /**
     * 查询液化气第三方对接接口记录列表
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 液化气第三方对接接口记录集合
     */
    public List<TLpgThirdPartyDockingInterfaceRecord> selectTLpgThirdPartyDockingInterfaceRecordList(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord);

    /**
     * 新增液化气第三方对接接口记录
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 结果
     */
    public int insertTLpgThirdPartyDockingInterfaceRecord(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord);

    /**
     * 批量插入
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgThirdPartyDockingInterfaceRecord> list);

    /**
     * 修改液化气第三方对接接口记录
     * 
     * @param tLpgThirdPartyDockingInterfaceRecord 液化气第三方对接接口记录
     * @return 结果
     */
    public int updateTLpgThirdPartyDockingInterfaceRecord(TLpgThirdPartyDockingInterfaceRecord tLpgThirdPartyDockingInterfaceRecord);

    /**
     * 删除液化气第三方对接接口记录
     * 
     * @param recordId 液化气第三方对接接口记录ID
     * @return 结果
     */
    public int deleteTLpgThirdPartyDockingInterfaceRecordById(Long recordId);

    /**
     * 批量删除液化气第三方对接接口记录
     * 
     * @param recordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgThirdPartyDockingInterfaceRecordByIds(Long[] recordIds);
}
