package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLinePatrol;

/**
 * 巡线Mapper接口
 *
 * @author zehong
 * @date 2026-02-02
 */
public interface TLinePatrolMapper
{
    /**
     * 查询巡线
     *
     * @param id 巡线ID
     * @return 巡线
     */
    public TLinePatrol selectTLinePatrolById(Long id);

    /**
     * 查询巡线列表
     *
     * @param tLinePatrol 巡线
     * @return 巡线集合
     */
    public List<TLinePatrol> selectTLinePatrolList(TLinePatrol tLinePatrol);

    /**
     * 新增巡线
     *
     * @param tLinePatrol 巡线
     * @return 结果
     */
    public int insertTLinePatrol(TLinePatrol tLinePatrol);

    /**
     * 修改巡线
     *
     * @param tLinePatrol 巡线
     * @return 结果
     */
    public int updateTLinePatrol(TLinePatrol tLinePatrol);

    /**
     * 删除巡线
     *
     * @param id 巡线ID
     * @return 结果
     */
    public int deleteTLinePatrolById(Long id);

    /**
     * 批量删除巡线
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLinePatrolByIds(Long[] ids);

    int insertBatch(List<TLinePatrol> tLinePatrol);
}