package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInspectionAccident;

/**
 * 巡检事故Mapper接口
 *
 * @author zehong
 * @date 2026-02-02
 */
public interface TInspectionAccidentMapper
{
    /**
     * 查询巡检事故
     *
     * @param id 巡检事故ID
     * @return 巡检事故
     */
    public TInspectionAccident selectTInspectionAccidentById(Long id);

    /**
     * 查询巡检事故列表
     *
     * @param tInspectionAccident 巡检事故
     * @return 巡检事故集合
     */
    public List<TInspectionAccident> selectTInspectionAccidentList(TInspectionAccident tInspectionAccident);

    /**
     * 新增巡检事故
     *
     * @param tInspectionAccident 巡检事故
     * @return 结果
     */
    public int insertTInspectionAccident(TInspectionAccident tInspectionAccident);

    /**
     * 修改巡检事故
     *
     * @param tInspectionAccident 巡检事故
     * @return 结果
     */
    public int updateTInspectionAccident(TInspectionAccident tInspectionAccident);

    /**
     * 删除巡检事故
     *
     * @param id 巡检事故ID
     * @return 结果
     */
    public int deleteTInspectionAccidentById(Long id);

    /**
     * 批量删除巡检事故
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInspectionAccidentByIds(Long[] ids);

    int insertBatch(List<TInspectionAccident> tInspectionAccident);
}