package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsHazRef;

/**
 * 监督检查-监督检查发现隐患及整改，执法结果Mapper接口
 * 
 * @author zehong
 * @date 2024-05-21
 */
public interface TInsHazRefMapper 
{
    /**
     * 查询监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param fInsHazRefId 监督检查-监督检查发现隐患及整改，执法结果ID
     * @return 监督检查-监督检查发现隐患及整改，执法结果
     */
    public TInsHazRef selectTInsHazRefById(Long fInsHazRefId);

    /**
     * 查询监督检查-监督检查发现隐患及整改，执法结果列表
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 监督检查-监督检查发现隐患及整改，执法结果集合
     */
    public List<TInsHazRef> selectTInsHazRefList(TInsHazRef tInsHazRef);

    /**
     * 新增监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 结果
     */
    public int insertTInsHazRef(TInsHazRef tInsHazRef);

    /**
     * 修改监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 结果
     */
    public int updateTInsHazRef(TInsHazRef tInsHazRef);

    /**
     * 删除监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param fInsHazRefId 监督检查-监督检查发现隐患及整改，执法结果ID
     * @return 结果
     */
    public int deleteTInsHazRefById(Long fInsHazRefId);

    /**
     * 批量删除监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param fInsHazRefIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsHazRefByIds(Long[] fInsHazRefIds);

    int deleteTInsHazRefByCheckCode(String fCheckCode);
}
