package com.zehong.system.mapper;

import com.zehong.system.domain.TGasUserInfo;

import java.util.List;

/**
 * 燃气用户Mapper接口
 *
 * @author zehong
 * @date 2023-08-17
 */
public interface TGasUserInfoMapper
{
    /**
     * 查询燃气用户
     *
     * @param gasUserId 燃气用户ID
     * @return 燃气用户
     */
    public TGasUserInfo selectTGasUserInfoById(Long gasUserId);

    /**
     * 查询燃气用户列表
     *
     * @param tGasUserInfo 燃气用户
     * @return 燃气用户集合
     */
    public List<TGasUserInfo> selectTGasUserInfoList(TGasUserInfo tGasUserInfo);

    /**
     * 新增燃气用户
     *
     * @param tGasUserInfo 燃气用户
     * @return 结果
     */
    public int insertTGasUserInfo(TGasUserInfo tGasUserInfo);

    /**
     * 修改燃气用户
     *
     * @param tGasUserInfo 燃气用户
     * @return 结果
     */
    public int updateTGasUserInfo(TGasUserInfo tGasUserInfo);

    /**
     * 删除燃气用户
     *
     * @param gasUserId 燃气用户ID
     * @return 结果
     */
    public int deleteTGasUserInfoById(Long gasUserId);

    /**
     * 批量删除燃气用户
     *
     * @param gasUserIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTGasUserInfoByIds(Long[] gasUserIds);

    /**
     * 查询燃气用户信息
     * @param tGasUserInfo
     * @return
     */
    List<TGasUserInfo> gasUser(TGasUserInfo tGasUserInfo);
}
