package com.zehong.system.mapper;

import com.zehong.system.domain.TDeliveryRecord;

import java.util.List;

/**
 * 配送记录Mapper接口
 * 
 * @author zehong
 * @date 2023-08-22
 */
public interface TDeliveryRecordMapper 
{
    /**
     * 查询配送记录
     * 
     * @param deliveryRecordId 配送记录ID
     * @return 配送记录
     */
    public TDeliveryRecord selectTDeliveryRecordById(Long deliveryRecordId);

    /**
     * 查询配送记录列表
     * 
     * @param tDeliveryRecord 配送记录
     * @return 配送记录集合
     */
    public List<TDeliveryRecord> selectTDeliveryRecordList(TDeliveryRecord tDeliveryRecord);

    /**
     * 新增配送记录
     * 
     * @param tDeliveryRecord 配送记录
     * @return 结果
     */
    public int insertTDeliveryRecord(TDeliveryRecord tDeliveryRecord);

    /**
     * 修改配送记录
     * 
     * @param tDeliveryRecord 配送记录
     * @return 结果
     */
    public int updateTDeliveryRecord(TDeliveryRecord tDeliveryRecord);

    /**
     * 删除配送记录
     * 
     * @param deliveryRecordId 配送记录ID
     * @return 结果
     */
    public int deleteTDeliveryRecordById(Long deliveryRecordId);

    /**
     * 批量删除配送记录
     * 
     * @param deliveryRecordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeliveryRecordByIds(Long[] deliveryRecordIds);
}
