package com.zehong.system.domain.vo;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;

import java.util.Date;

/**
 * 液化石油配送记录对象 t_lpg_delivery_record
 *
 * @author zehong
 * @date 2024-09-10
 */
public class TLpgDeliveryRecordImportVo {

    /** 储配站 */
    @Excel(name = "储配站")
    private String stationName;

    @Excel(name = "气瓶条码")
    private String bottleCode;

    /** 配送人员 */
    @Excel(name = "配送人员")
    private String deliveryPerson;

    /** 车辆代码 */
    @Excel(name = "车辆代码")
    private String vehicleCode;

    /** 用户账号 */
    @Excel(name = "用户自有编号")
    private String userOwnId;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 0.居民 1.非居民 */
    @Excel(name = "用户类型(0=居民,1=非居民)")
    private String gasUserType;

    /** 配送地址 */
    @Excel(name = "配送地址")
    private String deliveryAddress;

    /** 配送时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "配送时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date deliveryDate;

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getBottleCode() {
        return bottleCode;
    }

    public void setBottleCode(String bottleCode) {
        this.bottleCode = bottleCode;
    }

    public String getDeliveryPerson() {
        return deliveryPerson;
    }

    public void setDeliveryPerson(String deliveryPerson) {
        this.deliveryPerson = deliveryPerson;
    }

    public String getVehicleCode() {
        return vehicleCode;
    }

    public void setVehicleCode(String vehicleCode) {
        this.vehicleCode = vehicleCode;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getGasUserType() {
        return gasUserType;
    }

    public void setGasUserType(String gasUserType) {
        this.gasUserType = gasUserType;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
}
