package com.zehong.system.domain.form;


import lombok.Data;

import javax.validation.constraints.NotEmpty;

@Data
public class TDetectorReportDataForm {
	
	//数据上报原始ID必填  正常数据为用户名，报警数据为用户名+主键id
	@NotEmpty(message="数据上报原始ID必填")
	private String sourceId;
	
	@NotEmpty(message="设备编号必填")
    private String deviceNo;
	
	//报警设备类型，1探测器，2智慧用电
	private String deviceType;

	//探测器 推送数据（1正常，7、9离线，其他值预警）
    private String deviceStatusId;

    //状态名称
    private String statusName;

    private String reportValue;

    private String zhHostStatusId;

    private String netPoint;

    private String signalStrength;

    private String ipAddress;

    //创建时间
    @NotEmpty(message="上报时间必填")
    private String createTime;
    

}
