package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 液化石油气监管-液化气用户-安全装置加装维护对象 t_yehuaqiuser_safety_device_info
 * 
 * @author zehong
 * @date 2024-09-09
 */
public class TYehuaqiuserSafetyDeviceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 安全装置ID */
    private Long fSafetyDeviceId;

    /** 用户管理-燃气用户关联id */
    @Excel(name = "用户管理-燃气用户关联id")
    private Long fRelationUserId;

    /** 关联设备类型 */
    @Excel(name = "关联设备类型")
    private String fRelationDeviceType;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String fDeviceName;

    /** 设备型号 */
    @Excel(name = "设备型号")
    private String fDeviceModel;

    /** 物联网编号 */
    @Excel(name = "物联网编号")
    private String fIotNo;

    /** 探测介质 */
    @Excel(name = "探测介质")
    private String fDetectionMedium;

    /** 设备安装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "设备安装时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fDeviceInstallTime;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String fDeviceInstallPosition;

    /** 负责人 */
    @Excel(name = "负责人")
    private String fHead;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String fPhone;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setfSafetyDeviceId(Long fSafetyDeviceId) 
    {
        this.fSafetyDeviceId = fSafetyDeviceId;
    }

    public Long getfSafetyDeviceId() 
    {
        return fSafetyDeviceId;
    }
    public void setfRelationUserId(Long fRelationUserId) 
    {
        this.fRelationUserId = fRelationUserId;
    }

    public Long getfRelationUserId() 
    {
        return fRelationUserId;
    }
    public void setfRelationDeviceType(String fRelationDeviceType) 
    {
        this.fRelationDeviceType = fRelationDeviceType;
    }

    public String getfRelationDeviceType() 
    {
        return fRelationDeviceType;
    }
    public void setfDeviceName(String fDeviceName) 
    {
        this.fDeviceName = fDeviceName;
    }

    public String getfDeviceName() 
    {
        return fDeviceName;
    }
    public void setfDeviceModel(String fDeviceModel) 
    {
        this.fDeviceModel = fDeviceModel;
    }

    public String getfDeviceModel() 
    {
        return fDeviceModel;
    }
    public void setfIotNo(String fIotNo) 
    {
        this.fIotNo = fIotNo;
    }

    public String getfIotNo() 
    {
        return fIotNo;
    }
    public void setfDetectionMedium(String fDetectionMedium) 
    {
        this.fDetectionMedium = fDetectionMedium;
    }

    public String getfDetectionMedium() 
    {
        return fDetectionMedium;
    }
    public void setfDeviceInstallTime(Date fDeviceInstallTime) 
    {
        this.fDeviceInstallTime = fDeviceInstallTime;
    }

    public Date getfDeviceInstallTime() 
    {
        return fDeviceInstallTime;
    }
    public void setfDeviceInstallPosition(String fDeviceInstallPosition) 
    {
        this.fDeviceInstallPosition = fDeviceInstallPosition;
    }

    public String getfDeviceInstallPosition() 
    {
        return fDeviceInstallPosition;
    }
    public void setfHead(String fHead) 
    {
        this.fHead = fHead;
    }

    public String getfHead() 
    {
        return fHead;
    }
    public void setfPhone(String fPhone) 
    {
        this.fPhone = fPhone;
    }

    public String getfPhone() 
    {
        return fPhone;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fSafetyDeviceId", getfSafetyDeviceId())
            .append("fRelationUserId", getfRelationUserId())
            .append("fRelationDeviceType", getfRelationDeviceType())
            .append("fDeviceName", getfDeviceName())
            .append("fDeviceModel", getfDeviceModel())
            .append("fIotNo", getfIotNo())
            .append("fDetectionMedium", getfDetectionMedium())
            .append("fDeviceInstallTime", getfDeviceInstallTime())
            .append("fDeviceInstallPosition", getfDeviceInstallPosition())
            .append("fHead", getfHead())
            .append("fPhone", getfPhone())
            .append("isDel", getIsDel())
            .toString();
    }
}
