package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import com.zehong.system.domain.vo.UserManageSafetyDeviceExportVo;
import com.zehong.system.domain.vo.YeHuaqiUserManageSafetyDeviceExportVo;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气用户对象 t_yehuaqi_user
 * 
 * @author zehong
 * @date 2022-09-14
 */
public class TYehuaqiUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 用户id */
    private Long userId;

    /**
     * 用户自有id - 新版本导入时使用，别的地方不用
     */
    private String userOwnId;


    /** 用户账号 */
    @Excel(name = "用户账号")
    private String username;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 权属单位id */
    //@Excel(name = "权属单位id")
    private String beyondEnterpriseId;

    /**
     * 所属企业名称
     */
    @Excel(name = "所属企业")
    private String beyondEnterpriseName;

    /** 用户类型 */
    @Excel(name = "用户类型")
    private String userType;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 邮箱 */
    @Excel(name = "邮箱")
    private String email;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    private String remarks;

    private Integer deviceNum;

    private Integer zxnum;

    /**
     * 居住区村庄id
     */
    private Long villageId;

    /**
     * 居住区村庄名称
     */
    @Excel(name = "居住区(村、庄)")
    private String villageName;


    private String errorMsg;


    /**
     * 安全装置集合 导出时使用
     */
    private List<YeHuaqiUserManageSafetyDeviceExportVo> userManageSafetyDeviceExportVos;

    public List<YeHuaqiUserManageSafetyDeviceExportVo> getUserManageSafetyDeviceExportVos() {
        return userManageSafetyDeviceExportVos;
    }

    public void setUserManageSafetyDeviceExportVos(List<YeHuaqiUserManageSafetyDeviceExportVo> userManageSafetyDeviceExportVos) {
        this.userManageSafetyDeviceExportVos = userManageSafetyDeviceExportVos;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public Integer getZxnum() {
        return zxnum;
    }

    public void setZxnum(Integer zxnum) {
        this.zxnum = zxnum;
    }

    public Integer getDeviceNum() {
        return deviceNum;
    }

    public void setDeviceNum(Integer deviceNum) {
        this.deviceNum = deviceNum;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setNickName(String nickName) 
    {
        this.nickName = nickName;
    }

    public String getNickName() 
    {
        return nickName;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setUserType(String userType) 
    {
        this.userType = userType;
    }

    public String getUserType() 
    {
        return userType;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setLinkman(String linkman) 
    {
        this.linkman = linkman;
    }

    public String getLinkman() 
    {
        return linkman;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setEmail(String email) 
    {
        this.email = email;
    }

    public String getEmail() 
    {
        return email;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public Long getVillageId() {
        return villageId;
    }

    public void setVillageId(Long villageId) {
        this.villageId = villageId;
    }

    public String getVillageName() {
        return villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TYehuaqiUser yehuaqiUser = (TYehuaqiUser) obj;
        return Objects.equals(userOwnId,yehuaqiUser.getUserOwnId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(userOwnId);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("userId", getUserId())
            .append("username", getUsername())
            .append("nickName", getNickName())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("userType", getUserType())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("linkman", getLinkman())
            .append("phone", getPhone())
            .append("email", getEmail())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
