package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 巡检巡查任务对象 t_work_task
 * 
 * @author zehong
 * @date 2023-09-14
 */
public class TWorkTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 任务id */
    private Long taskId;

    /** 1巡线 2入户安检 */
    @Excel(name = "1巡线 2入户安检")
    private Integer taskType;

    /** 任务标题 */
    @Excel(name = "任务标题")
    private String taskTitle;

    /** 任务内容 */
    @Excel(name = "任务内容")
    private String taskContent;

    /** 状态 0进行中 1已关闭 */
    @Excel(name = "状态 0进行中 1已关闭")
    private Integer status;

    /** 创建企业id */
    @Excel(name = "创建企业id")
    private String createEnterpriseId;

    private String groupNum;

    private String[] personIds;
    //是否进行中
    private Integer progress;
    private Long taskMemberId;

    public Long getTaskMemberId() {
        return taskMemberId;
    }

    public void setTaskMemberId(Long taskMemberId) {
        this.taskMemberId = taskMemberId;
    }

    public Integer getProgress() {
        return progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public String[] getPersonIds() {
        return personIds;
    }

    public void setPersonIds(String[] personIds) {
        this.personIds = personIds;
    }

    public String getGroupNum() {
        return groupNum;
    }

    public void setGroupNum(String groupNum) {
        this.groupNum = groupNum;
    }

    /** 结束结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "结束结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 是否上报 0否 1是 */
    @Excel(name = "是否上报 0否 1是")
    private Integer isReport;

    /** 是否删除 0否 1是 */
    @Excel(name = "是否删除 0否 1是")
    private Integer isDel;

    private Long memberId;

    private Integer userType;

    /**审批意见*/
    private String approvalSuggestion;

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    private List<TWorkTaskMember> taskMemberList;

    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setTaskType(Integer taskType) 
    {
        this.taskType = taskType;
    }

    public Integer getTaskType() 
    {
        return taskType;
    }
    public void setTaskTitle(String taskTitle) 
    {
        this.taskTitle = taskTitle;
    }

    public String getTaskTitle() 
    {
        return taskTitle;
    }
    public void setTaskContent(String taskContent) 
    {
        this.taskContent = taskContent;
    }

    public String getTaskContent() 
    {
        return taskContent;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setCreateEnterpriseId(String createEnterpriseId)
    {
        this.createEnterpriseId = createEnterpriseId;
    }

    public String getCreateEnterpriseId()
    {
        return createEnterpriseId;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setIsReport(Integer isReport) 
    {
        this.isReport = isReport;
    }

    public Integer getIsReport() 
    {
        return isReport;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    public List<TWorkTaskMember> getTaskMemberList() {
        return taskMemberList;
    }

    public void setTaskMemberList(List<TWorkTaskMember> taskMemberList) {
        this.taskMemberList = taskMemberList;
    }

    public String getApprovalSuggestion() {
        return approvalSuggestion;
    }

    public void setApprovalSuggestion(String approvalSuggestion) {
        this.approvalSuggestion = approvalSuggestion;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("taskId", getTaskId())
            .append("taskType", getTaskType())
            .append("taskTitle", getTaskTitle())
            .append("taskContent", getTaskContent())
            .append("status", getStatus())
            .append("createEnterpriseId", getCreateEnterpriseId())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("endTime", getEndTime())
            .append("isReport", getIsReport())
            .append("isDel", getIsDel())
            .toString();
    }
}
