package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 调岗记录对象 t_transfer_post_record
 * 
 * @author zehong
 * @date 2023-09-21
 */
public class TTransferPostRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 调岗记录主键 */
    private Long recordId;

    /** 申请人 */
    @Excel(name = "申请人")
    private Long applyId;

    /** 组号 */
    @Excel(name = "组号")
    private String gruopNum;

    /** 组长id */
    @Excel(name = "组长id")
    private Long captainId;

    /** 调换组号 */
    @Excel(name = "调换组号")
    private String transferGroupNum;

    /** 调换组长id */
    @Excel(name = "调换组长id")
    private Long transferCaptainId;

    /** 状态：0.待审核 1.通过 2.驳回 */
    @Excel(name = "状态：0.待审核 1.通过 2.驳回")
    private String transferStatus;

    /** 意见建议 */
    @Excel(name = "意见建议")
    private String suggestion;

    private String personName;
    private String groupName;
    private String transferGroupName;

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getTransferGroupName() {
        return transferGroupName;
    }

    public void setTransferGroupName(String transferGroupName) {
        this.transferGroupName = transferGroupName;
    }

    public void setRecordId(Long recordId)
    {
        this.recordId = recordId;
    }

    public Long getRecordId() 
    {
        return recordId;
    }
    public void setApplyId(Long applyId) 
    {
        this.applyId = applyId;
    }

    public Long getApplyId() 
    {
        return applyId;
    }
    public void setGruopNum(String gruopNum) 
    {
        this.gruopNum = gruopNum;
    }

    public String getGruopNum() 
    {
        return gruopNum;
    }
    public void setCaptainId(Long captainId) 
    {
        this.captainId = captainId;
    }

    public Long getCaptainId() 
    {
        return captainId;
    }
    public void setTransferGroupNum(String transferGroupNum) 
    {
        this.transferGroupNum = transferGroupNum;
    }

    public String getTransferGroupNum() 
    {
        return transferGroupNum;
    }
    public void setTransferCaptainId(Long transferCaptainId) 
    {
        this.transferCaptainId = transferCaptainId;
    }

    public Long getTransferCaptainId() 
    {
        return transferCaptainId;
    }
    public void setTransferStatus(String transferStatus) 
    {
        this.transferStatus = transferStatus;
    }

    public String getTransferStatus() 
    {
        return transferStatus;
    }
    public void setSuggestion(String suggestion) 
    {
        this.suggestion = suggestion;
    }

    public String getSuggestion() 
    {
        return suggestion;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("recordId", getRecordId())
            .append("applyId", getApplyId())
            .append("gruopNum", getGruopNum())
            .append("captainId", getCaptainId())
            .append("transferGroupNum", getTransferGroupNum())
            .append("transferCaptainId", getTransferCaptainId())
            .append("transferStatus", getTransferStatus())
            .append("suggestion", getSuggestion())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
