package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 乡级行政区对象 t_town_level_region
 * 
 * @author zehong
 * @date 2024-06-07
 */
public class TTownLevelRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /**  乡镇级行政区 ID，表主键，非自 */
    private Long fId;

    /** 所属县区 i */
    @Excel(name = "所属县区 i")
    private Long fCountyId;

    /** 乡镇行政区划编码 */
    @Excel(name = "乡镇行政区划编码")
    private String fTownCode;

    /** 乡镇名称 */
    @Excel(name = "乡镇名称")
    private String fName;

    public void setfId(Long fId) 
    {
        this.fId = fId;
    }

    public Long getfId() 
    {
        return fId;
    }
    public void setfCountyId(Long fCountyId) 
    {
        this.fCountyId = fCountyId;
    }

    public Long getfCountyId() 
    {
        return fCountyId;
    }
    public void setfTownCode(String fTownCode) 
    {
        this.fTownCode = fTownCode;
    }

    public String getfTownCode() 
    {
        return fTownCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fId", getfId())
            .append("fCountyId", getfCountyId())
            .append("fTownCode", getfTownCode())
            .append("fName", getfName())
            .toString();
    }
}
