package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查对象 t_supervise
 * 
 * @author zehong
 * @date 2024-02-04
 */
public class TSupervise extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 内容 */
    @Excel(name = "内容")
    private String content;

    /** 检查结果 */
    @Excel(name = "检查结果")
    private String resultContent;

    /** 检察人 */
    @Excel(name = "检察人")
    private String person;

    /** 检查地址 */
    @Excel(name = "检查地址")
    private String address;

    /** 经度 */
    private String longitude;

    /** 纬度 */
    private String latitude;

    /** 企业id */
    @Excel(name = "企业id")
    private Long enterpriseId;

    /** 现场图片 */
    private String pictrueUrl;

    /** 现场视频 */
    private String vedioUrl;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setResultContent(String resultContent) 
    {
        this.resultContent = resultContent;
    }

    public String getResultContent() 
    {
        return resultContent;
    }
    public void setPerson(String person) 
    {
        this.person = person;
    }

    public String getPerson() 
    {
        return person;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(String longitude) 
    {
        this.longitude = longitude;
    }

    public String getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(String latitude) 
    {
        this.latitude = latitude;
    }

    public String getLatitude() 
    {
        return latitude;
    }
    public void setEnterpriseId(Long enterpriseId) 
    {
        this.enterpriseId = enterpriseId;
    }

    public Long getEnterpriseId() 
    {
        return enterpriseId;
    }
    public void setPictrueUrl(String pictrueUrl) 
    {
        this.pictrueUrl = pictrueUrl;
    }

    public String getPictrueUrl() 
    {
        return pictrueUrl;
    }
    public void setVedioUrl(String vedioUrl) 
    {
        this.vedioUrl = vedioUrl;
    }

    public String getVedioUrl() 
    {
        return vedioUrl;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("content", getContent())
            .append("resultContent", getResultContent())
            .append("person", getPerson())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("enterpriseId", getEnterpriseId())
            .append("pictrueUrl", getPictrueUrl())
            .append("vedioUrl", getVedioUrl())
            .append("createTime", getCreateTime())
            .toString();
    }
}
