package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检点对象 t_patrol_position
 * 
 * @author zehong
 * @date 2023-08-05
 */
public class TPatrolPosition extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检点id */
    private Long patrolId;

    /** 巡检点名称 */
    @Excel(name = "巡检点名称")
    private String patrolName;

    /** 巡检点类型 */
    @Excel(name = "巡检点类型")
    private Integer patrolType;

    /** 经度 */
    @Excel(name = "经度")
    private String longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private String latitude;

    /** 位置描述 */
    @Excel(name = "位置描述")
    private String position;

    /** 巡检点参数 */
    @Excel(name = "巡检点参数")
    private String patrolDetail;

    /** $column.columnComment */
    @Excel(name = "巡检点参数")
    private Long deptId;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 0未删除 1已删除 */
    @Excel(name = "0未删除 1已删除")
    private Integer isDel;

    public void setPatrolId(Long patrolId) 
    {
        this.patrolId = patrolId;
    }

    public Long getPatrolId() 
    {
        return patrolId;
    }
    public void setPatrolName(String patrolName) 
    {
        this.patrolName = patrolName;
    }

    public String getPatrolName() 
    {
        return patrolName;
    }
    public void setPatrolType(Integer patrolType) 
    {
        this.patrolType = patrolType;
    }

    public Integer getPatrolType() 
    {
        return patrolType;
    }
    public void setLongitude(String longitude) 
    {
        this.longitude = longitude;
    }

    public String getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(String latitude) 
    {
        this.latitude = latitude;
    }

    public String getLatitude() 
    {
        return latitude;
    }
    public void setPosition(String position) 
    {
        this.position = position;
    }

    public String getPosition() 
    {
        return position;
    }
    public void setPatrolDetail(String patrolDetail) 
    {
        this.patrolDetail = patrolDetail;
    }

    public String getPatrolDetail() 
    {
        return patrolDetail;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("patrolId", getPatrolId())
            .append("patrolName", getPatrolName())
            .append("patrolType", getPatrolType())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("position", getPosition())
            .append("patrolDetail", getPatrolDetail())
            .append("deptId", getDeptId())
            .append("remarks", getRemarks())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .append("isDel", getIsDel())
            .toString();
    }
}
