package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Objects;

/**
 * 液化石油气-充装记录对象 t_lpg_air_charge_files
 * 
 * @author zehong
 * @date 2024-07-09
 */
public class TLpgAirChargeFiles extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long gasAirChargeId;

    /**
     * 燃气企业ID
     */
    private String enterpriseId;

    /**
     * 燃气企业名称
     */
    @Excel(name = "燃气企业")
    private String enterpriseName;

    /** 充装记录编号 */
    @Excel(name = "充装记录编号")
    private Long gzId;

    /** 充装单位 */
    @Excel(name = "充装单位")
    private String stationName;

    /** 气瓶条码 */
    @Excel(name = "气瓶条码")
    private String barCode;

    /** 钢印号 */
    @Excel(name = "钢印号")
    private String vaseCode;

    /** 秤号 */
    @Excel(name = "秤号")
    private String scaleNum;

    /** 充装开始时间 */
    @Excel(name = "充装开始时间")
    private String fillStatrTime;

    /** 充装结束时间 */
    @Excel(name = "充装结束时间")
    private String fillEndTime;

    /** 设定净重 */
    @Excel(name = "设定净重")
    private String setWeight;

    /** 实际净重 */
    @Excel(name = "实际净重")
    private String wtNet;

    /** 设定瓶重 */
    @Excel(name = "设定瓶重")
    private String setBottleWeight;

    /** 实际瓶重 */
    @Excel(name = "实际瓶重")
    private String bottleWeight;

    /** 实际总重 */
    @Excel(name = "实际总重")
    private String wtGross;

    /** 充装工 */
    @Excel(name = "充装工")
    private String oprateName;

    public Long getGasAirChargeId() {
        return gasAirChargeId;
    }

    public void setGasAirChargeId(Long gasAirChargeId) {
        this.gasAirChargeId = gasAirChargeId;
    }

    public Long getGzId() {
        return gzId;
    }

    public void setGzId(Long gzId) {
        this.gzId = gzId;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getVaseCode() {
        return vaseCode;
    }

    public void setVaseCode(String vaseCode) {
        this.vaseCode = vaseCode;
    }

    public String getScaleNum() {
        return scaleNum;
    }

    public void setScaleNum(String scaleNum) {
        this.scaleNum = scaleNum;
    }

    public String getFillStatrTime() {
        return fillStatrTime;
    }

    public void setFillStatrTime(String fillStatrTime) {
        this.fillStatrTime = fillStatrTime;
    }

    public String getFillEndTime() {
        return fillEndTime;
    }

    public void setFillEndTime(String fillEndTime) {
        this.fillEndTime = fillEndTime;
    }

    public String getSetWeight() {
        return setWeight;
    }

    public void setSetWeight(String setWeight) {
        this.setWeight = setWeight;
    }

    public String getWtNet() {
        return wtNet;
    }

    public void setWtNet(String wtNet) {
        this.wtNet = wtNet;
    }

    public String getSetBottleWeight() {
        return setBottleWeight;
    }

    public void setSetBottleWeight(String setBottleWeight) {
        this.setBottleWeight = setBottleWeight;
    }

    public String getBottleWeight() {
        return bottleWeight;
    }

    public void setBottleWeight(String bottleWeight) {
        this.bottleWeight = bottleWeight;
    }

    public String getWtGross() {
        return wtGross;
    }

    public void setWtGross(String wtGross) {
        this.wtGross = wtGross;
    }

    public String getOprateName() {
        return oprateName;
    }

    public void setOprateName(String oprateName) {
        this.oprateName = oprateName;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TLpgAirChargeFiles lpgAirChargeFiles = (TLpgAirChargeFiles) obj;
        return Objects.equals(barCode,lpgAirChargeFiles.getBarCode()) && Objects.equals(gzId,lpgAirChargeFiles.getGzId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(barCode,gzId);
    }

    @Override
    public String toString() {
        return "TLpgAirChargeFiles{" +
                "gasAirChargeId=" + gasAirChargeId +
                ", gzId=" + gzId +
                ", stationName='" + stationName + '\'' +
                ", barCode='" + barCode + '\'' +
                ", vaseCode='" + vaseCode + '\'' +
                ", scaleNum='" + scaleNum + '\'' +
                ", fillStatrTime='" + fillStatrTime + '\'' +
                ", fillEndTime='" + fillEndTime + '\'' +
                ", setWeight='" + setWeight + '\'' +
                ", wtNet='" + wtNet + '\'' +
                ", setBottleWeight='" + setBottleWeight + '\'' +
                ", bottleWeight='" + bottleWeight + '\'' +
                ", wtGross='" + wtGross + '\'' +
                ", oprateName='" + oprateName + '\'' +
                '}';
    }
}
