package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡线人员管理对象 t_line_patrol_person
 * 
 * @author zehong
 * @date 2023-09-13
 */
public class TLinePatrolPerson extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡线人员主键 */
    private Long personId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String personName;

    /** 电话 */
    @Excel(name = "电话")
    private String phoneNum;

    /** 职务 */
    @Excel(name = "职务")
    private String personPost;

    /** 组号 */
    @Excel(name = "组号")
    private String groupNum;

    /** $column.columnComment */
    @Excel(name = "组号")
    private String beyondEnterpriseId;

    /** 账号 */
    @Excel(name = "账号")
    private String personAccount;

    /** 密码 */
    @Excel(name = "密码")
    private String personPassword;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private String groupName;

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setPersonId(Long personId)
    {
        this.personId = personId;
    }

    public Long getPersonId() 
    {
        return personId;
    }
    public void setPersonName(String personName) 
    {
        this.personName = personName;
    }

    public String getPersonName() 
    {
        return personName;
    }
    public void setPhoneNum(String phoneNum) 
    {
        this.phoneNum = phoneNum;
    }

    public String getPhoneNum() 
    {
        return phoneNum;
    }
    public void setPersonPost(String personPost) 
    {
        this.personPost = personPost;
    }

    public String getPersonPost() 
    {
        return personPost;
    }
    public void setGroupNum(String groupNum) 
    {
        this.groupNum = groupNum;
    }

    public String getGroupNum() 
    {
        return groupNum;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setPersonAccount(String personAccount)
    {
        this.personAccount = personAccount;
    }

    public String getPersonAccount() 
    {
        return personAccount;
    }
    public void setPersonPassword(String personPassword) 
    {
        this.personPassword = personPassword;
    }

    public String getPersonPassword() 
    {
        return personPassword;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("personId", getPersonId())
            .append("personName", getPersonName())
            .append("phoneNum", getPhoneNum())
            .append("personPost", getPersonPost())
            .append("groupNum", getGroupNum())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("personAccount", getPersonAccount())
            .append("personPassword", getPersonPassword())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
