package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 双代台账对象 t_double_book
 * 
 * @author zehong
 * @date 2024-04-21
 */
public class TDoubleBook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long bookId;

    /** 所属企业id */
    private String beyondEnterpriseId;

    @Excel(name = "所属企业")
    private String beyondEnterpriseName;

    /** 户主姓名 */
    @Excel(name = "户主姓名")
    private String username;

    /** 户主电话 */
    @Excel(name = "户主电话")
    private String phone;

    /** 改造类型 */
    @Excel(name = "改造类型",dictType = "t_double_type")
    private String type;

    /** 完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd  HH:mm:ss")
    private Date finishTime;

    /** 用气量 */
    @Excel(name = "用气量")
    private float dosage;

    /** 0正常 1停用 */
    @Excel(name = "状态",readConverterExp = "0=正常,1=停用")
    private Integer status;

    /** 所属区域 */
    private Long township;

    @Excel(name = "所属区域")
    private String townshipName;

    /** 房屋位置 */
    @Excel(name = "房屋位置")
    private String housesAddress;

    /** 房屋信息 */
    @Excel(name = "房屋信息")
    private String housesInfo;

    /** 0未删除 1已删除 */
    private Integer isDel;

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public void setBookId(Long bookId)
    {
        this.bookId = bookId;
    }

    public Long getBookId() 
    {
        return bookId;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setFinishTime(Date finishTime) 
    {
        this.finishTime = finishTime;
    }

    public Date getFinishTime() 
    {
        return finishTime;
    }
    public void setDosage(float dosage)
    {
        this.dosage = dosage;
    }

    public float getDosage()
    {
        return dosage;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setTownship(Long township)
    {
        this.township = township;
    }

    public Long getTownship()
    {
        return township;
    }
    public void setHousesAddress(String housesAddress) 
    {
        this.housesAddress = housesAddress;
    }

    public String getHousesAddress() 
    {
        return housesAddress;
    }
    public void setHousesInfo(String housesInfo) 
    {
        this.housesInfo = housesInfo;
    }

    public String getHousesInfo() 
    {
        return housesInfo;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    public String getTownshipName() {
        return townshipName;
    }

    public void setTownshipName(String townshipName) {
        this.townshipName = townshipName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bookId", getBookId())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("username", getUsername())
            .append("phone", getPhone())
            .append("type", getType())
            .append("finishTime", getFinishTime())
            .append("dosage", getDosage())
            .append("status", getStatus())
            .append("township", getTownship())
            .append("housesAddress", getHousesAddress())
            .append("housesInfo", getHousesInfo())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .toString();
    }
}
