package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 配送记录对象 t_delivery_record
 *
 * @author zehong
 * @date 2023-08-22
 */
public class TDeliveryRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 配送记录主键 */
    private Long deliveryRecordId;

    /** 储配站主键 */
    @Excel(name = "储配站主键")
    private Long stationId;

    /** 气瓶主键 */
    @Excel(name = "气瓶主键")
    private Long bottleId;

    /** 配送人员 */
    @Excel(name = "配送人员")
    private String deliveryPerson;

    /*配送人员名称*/
    private String deliveryPersonName;

    /** 车辆代码 */
    @Excel(name = "车辆代码")
    private String vehicleCode;

    /** 用户主键 */
    @Excel(name = "用户主键")
    private Long gasUserId;

    /** 配送地址 */
    @Excel(name = "配送地址")
    private String deliveryAddress;

    /** 配送时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "配送时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date deliveryDate;

    /** 删除状态：0.否 1.是 */
    @Excel(name = "删除状态：0.否 1.是")
    private String isDel;

    /**
     * 储配站名称
     */
    private String stationName;


    /**
     * 气瓶条码
     */
    private String bottleCode;

    /**
     * 气瓶规格
     */
    private String bottleSpecs;

    /**
     * 气瓶状态 1正常 2逾期未检 3报废
     */
    private Integer bottleStatus;

    /**
     * 用户名称
     */
    private String gasUserName;

    /**
     * 用户类型  0居民  1非居民
     */
    private String gasUserType;

    public String getDeliveryPersonName() {
        return deliveryPersonName;
    }

    public void setDeliveryPersonName(String deliveryPersonName) {
        this.deliveryPersonName = deliveryPersonName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getBottleCode() {
        return bottleCode;
    }

    public void setBottleCode(String bottleCode) {
        this.bottleCode = bottleCode;
    }

    public String getBottleSpecs() {
        return bottleSpecs;
    }

    public void setBottleSpecs(String bottleSpecs) {
        this.bottleSpecs = bottleSpecs;
    }

    public Integer getBottleStatus() {
        return bottleStatus;
    }

    public void setBottleStatus(Integer bottleStatus) {
        this.bottleStatus = bottleStatus;
    }

    public String getGasUserName() {
        return gasUserName;
    }

    public void setGasUserName(String gasUserName) {
        this.gasUserName = gasUserName;
    }

    public String getGasUserType() {
        return gasUserType;
    }

    public void setGasUserType(String gasUserType) {
        this.gasUserType = gasUserType;
    }

    public void setDeliveryRecordId(Long deliveryRecordId)
    {
        this.deliveryRecordId = deliveryRecordId;
    }

    public Long getDeliveryRecordId()
    {
        return deliveryRecordId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setBottleId(Long bottleId)
    {
        this.bottleId = bottleId;
    }

    public Long getBottleId()
    {
        return bottleId;
    }

    public String getDeliveryPerson() {
        return deliveryPerson;
    }

    public void setDeliveryPerson(String deliveryPerson) {
        this.deliveryPerson = deliveryPerson;
    }

    public void setVehicleCode(String vehicleCode)
    {
        this.vehicleCode = vehicleCode;
    }

    public String getVehicleCode()
    {
        return vehicleCode;
    }
    public void setGasUserId(Long gasUserId)
    {
        this.gasUserId = gasUserId;
    }

    public Long getGasUserId()
    {
        return gasUserId;
    }
    public void setDeliveryAddress(String deliveryAddress)
    {
        this.deliveryAddress = deliveryAddress;
    }

    public String getDeliveryAddress()
    {
        return deliveryAddress;
    }
    public void setDeliveryDate(Date deliveryDate)
    {
        this.deliveryDate = deliveryDate;
    }

    public Date getDeliveryDate()
    {
        return deliveryDate;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return "TDeliveryRecord{" +
                "deliveryRecordId=" + deliveryRecordId +
                ", stationId=" + stationId +
                ", bottleId=" + bottleId +
                ", deliveryPerson='" + deliveryPerson + '\'' +
                ", deliveryPersonName='" + deliveryPersonName + '\'' +
                ", vehicleCode='" + vehicleCode + '\'' +
                ", gasUserId=" + gasUserId +
                ", deliveryAddress='" + deliveryAddress + '\'' +
                ", deliveryDate=" + deliveryDate +
                ", isDel='" + isDel + '\'' +
                ", stationName='" + stationName + '\'' +
                ", bottleCode='" + bottleCode + '\'' +
                ", bottleSpecs='" + bottleSpecs + '\'' +
                ", bottleStatus=" + bottleStatus +
                ", gasUserName='" + gasUserName + '\'' +
                ", gasUserType='" + gasUserType + '\'' +
                '}';
    }
}
