package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 燃气投诉处置-转办记录对象 t_complain_deal_transfer
 * 
 * @author zehong
 * @date 2024-06-14
 */
public class TComplainDealTransfer extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 投诉处置转办id */
    private Long complainDealTransferId;

    /** 投诉处置id */
    @Excel(name = "投诉处置id")
    private Long complainDealId;

    /** 企业id-省平台调整改成字符创 uuid */
    //@Excel(name = "企业id-省平台调整改成字符创 uuid")
    private String enterpriseId;

    /** 企业名称-结果反显 */
    @Excel(name = "企业名称-结果反显")
    private String enterpriseName;

    /** 指派人 */
    //@Excel(name = "指派人id")
    private Long complainAssignManId;

    /** 指派人 */
    @Excel(name = "指派人")
    private String complainAssignMan;

    /** 原因 */
    @Excel(name = "原因")
    private String reasonConcent;

    public void setComplainDealTransferId(Long complainDealTransferId) 
    {
        this.complainDealTransferId = complainDealTransferId;
    }

    public Long getComplainDealTransferId() 
    {
        return complainDealTransferId;
    }
    public void setComplainDealId(Long complainDealId) 
    {
        this.complainDealId = complainDealId;
    }

    public Long getComplainDealId() 
    {
        return complainDealId;
    }
    public void setEnterpriseId(String enterpriseId) 
    {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseId() 
    {
        return enterpriseId;
    }
    public void setEnterpriseName(String enterpriseName) 
    {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseName() 
    {
        return enterpriseName;
    }
    public void setReasonConcent(String reasonConcent) 
    {
        this.reasonConcent = reasonConcent;
    }

    public String getReasonConcent() 
    {
        return reasonConcent;
    }

    public Long getComplainAssignManId() {
        return complainAssignManId;
    }

    public void setComplainAssignManId(Long complainAssignManId) {
        this.complainAssignManId = complainAssignManId;
    }

    public String getComplainAssignMan() {
        return complainAssignMan;
    }

    public void setComplainAssignMan(String complainAssignMan) {
        this.complainAssignMan = complainAssignMan;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("complainDealTransferId", getComplainDealTransferId())
            .append("complainDealId", getComplainDealId())
            .append("enterpriseId", getEnterpriseId())
            .append("enterpriseName", getEnterpriseName())
            .append("reasonConcent", getReasonConcent())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .toString();
    }
}
