package com.zehong.system.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEventInfo;
import com.zehong.system.service.ITEventInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事件处置Controller
 * 
 * @author zehong
 * @date 2022-02-11
 */
@RestController
@RequestMapping("/system/eventInfo")
public class TEventInfoController extends BaseController
{
    @Autowired
    private ITEventInfoService tEventInfoService;

    /**
     * 查询事件处置列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEventInfo tEventInfo)
    {
        startPage();
        List<TEventInfo> list = tEventInfoService.selectTEventInfoList(tEventInfo);
        return getDataTable(list);
    }

    /**
     * 导出事件处置列表
     */
    @Log(title = "事件处置", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEventInfo tEventInfo)
    {
        List<TEventInfo> list = tEventInfoService.selectTEventInfoList(tEventInfo);
        ExcelUtil<TEventInfo> util = new ExcelUtil<TEventInfo>(TEventInfo.class);
        return util.exportExcel(list, "事件处置数据");
    }

    /**
     * 获取事件处置详细信息
     */
    @GetMapping(value = "/{eventId}")
    public AjaxResult getInfo(@PathVariable("eventId") Long eventId)
    {
        return AjaxResult.success(tEventInfoService.selectTEventInfoById(eventId));
    }

    /**
     * 新增事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEventInfo tEventInfo)
    {
        return toAjax(tEventInfoService.insertTEventInfo(tEventInfo));
    }

    /**
     * 修改事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEventInfo tEventInfo)
    {
        return toAjax(tEventInfoService.updateTEventInfo(tEventInfo));
    }

    /**
     * 删除事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{eventIds}")
    public AjaxResult remove(@PathVariable Long[] eventIds)
    {
        return toAjax(tEventInfoService.deleteTEventInfoByIds(eventIds));
    }
}
