package com.zehong.system.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEventHandle;
import com.zehong.system.service.ITEventHandleService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事件处置Controller
 * 
 * @author zehong
 * @date 2022-03-19
 */
@RestController
@RequestMapping("/system/handle")
public class TEventHandleController extends BaseController
{
    @Autowired
    private ITEventHandleService tEventHandleService;

    /**
     * 查询事件处置列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEventHandle tEventHandle)
    {
        startPage();
        List<TEventHandle> list = tEventHandleService.selectTEventHandleList(tEventHandle);
        return getDataTable(list);
    }

    /**
     * 导出事件处置列表
     */
    @Log(title = "事件处置", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEventHandle tEventHandle)
    {
        List<TEventHandle> list = tEventHandleService.selectTEventHandleList(tEventHandle);
        ExcelUtil<TEventHandle> util = new ExcelUtil<TEventHandle>(TEventHandle.class);
        return util.exportExcel(list, "事件处置数据");
    }

    /**
     * 获取事件处置详细信息
     */
    @GetMapping(value = "/{handleId}")
    public AjaxResult getInfo(@PathVariable("handleId") Long handleId)
    {
        return AjaxResult.success(tEventHandleService.selectTEventHandleById(handleId));
    }

    /**
     * 新增事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEventHandle tEventHandle)
    {
        return toAjax(tEventHandleService.insertTEventHandle(tEventHandle));
    }

    /**
     * 修改事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEventHandle tEventHandle)
    {
        return toAjax(tEventHandleService.updateTEventHandle(tEventHandle));
    }

    /**
     * 删除事件处置
     */
    @Log(title = "事件处置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{handleIds}")
    public AjaxResult remove(@PathVariable Long[] handleIds)
    {
        return toAjax(tEventHandleService.deleteTEventHandleByIds(handleIds));
    }
}
