package com.zehong.system.controller;

import com.zehong.common.annotation.RepeatSubmit;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.config.ureport.ResponseData;
import com.zehong.system.domain.BaseExportTemp;
import com.zehong.system.domain.dto.BaseTempExportDTO;
import com.zehong.system.service.IBaseExportTempService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;

/**
 * ureport2模板管理Controller
 *
 * @author wanghao
 * @date 2024-06-11
 */
@RestController
@RequestMapping("/base/baseExportTemp")
public class BaseExportTempController extends BaseController
{
    @Autowired
    private IBaseExportTempService baseExportTempService;

    @Autowired
    Environment environment;
    /**
     * 查询ureport2模板管理列表
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseExportTemp baseExportTemp)
    {
        startPage();
        List<BaseExportTemp> list = baseExportTempService.selectBaseExportTempList(baseExportTemp);
        return getDataTable(list);
    }

    /**
     * 导出ureport2模板管理列表
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:export')")
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseExportTemp baseExportTemp)
    {
        List<BaseExportTemp> list = baseExportTempService.selectBaseExportTempList(baseExportTemp);
        ExcelUtil<BaseExportTemp> util = new ExcelUtil<BaseExportTemp>(BaseExportTemp.class);
        util.exportExcel(list, "ureport2模板管理数据");
    }

    /**
     * 获取ureport2模板管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:query')")
    @GetMapping(value = "/{id}")
    public ResponseData<BaseExportTemp> getInfo(@PathVariable("id") Long id)
    {
        return ResponseData.success(baseExportTempService.selectBaseExportTempById(id));
    }

    /**
     * 新增ureport2模板管理
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:add')")
    @PostMapping
    @RepeatSubmit
    public ResponseData add(@RequestBody @Valid BaseExportTemp baseExportTemp)
    {
        int i = baseExportTempService.insertBaseExportTemp(baseExportTemp);
        if(i>0){
            //返回主键
            return ResponseData.success(baseExportTemp.getId());
        }else{
            return ResponseData.error();
        }
    }

    /**
     * 修改ureport2模板管理
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:edit')")
    @PutMapping
    @RepeatSubmit
    public ResponseData edit(@RequestBody @Valid BaseExportTemp baseExportTemp)
    {
        int i = baseExportTempService.updateBaseExportTemp(baseExportTemp);
        if(i>0){
            //返回主键
            return ResponseData.success(baseExportTemp.getId());
        }else{
            return ResponseData.error();
        }
    }

    /**
     * 删除ureport2模板管理
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:remove')")
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        //return toResult(baseExportTempService.deleteBaseExportTempByIds(ids));
        //逻辑删除
        return AjaxResult.success(baseExportTempService.setDeleteByIds(ids));
    }

    /**
     * 查询ureport2模板管理列表---不进行分页
     */
    @PreAuthorize("@ss.hasPermi('base:baseExportTemp:list')")
    @PostMapping("/getDataList")
    public ResponseData<List<BaseExportTemp>> getDataList(@RequestBody BaseExportTemp baseExportTemp)
    {
        List<BaseExportTemp> list = baseExportTempService.selectBaseExportTempList(baseExportTemp);
        return ResponseData.success(list);
    }

    /**
     * 跳转到添加模板页面
     * @return
     */
    @GetMapping("/addTemp")
    @PreAuthorize("@ss.hasPermi('baseExportTemp:baseExportTemp:add')")
    public String addTemp(){
//        return "http://"+ IpUtils.getHostIp() +":"+environment.getProperty("server.port")+"/ureport/designer";
        return environment.getProperty("zehong.ureporturl")+"/ureport/designer";
    }

    /**
     * 跳转到修改模板页面
     * @return
     */
    @GetMapping("/editTemp/{id}")
    @PreAuthorize("@ss.hasPermi('baseExportTemp:baseExportTemp:edit')")
    public String editTemp(@PathVariable Long id){
        BaseExportTemp baseExportTemp1 = baseExportTempService.selectBaseExportTempById(id);
        if(baseExportTemp1==null){
            throw new SecurityException("当前模板不存在");
        }
//        return "http://"+ IpUtils.getHostIp() +":"+environment.getProperty("server.port")+"/ureport/designer"+"?_u="+baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName();
        return environment.getProperty("zehong.ureporturl")+"/ureport/designer"+"?_u="+baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName();
    }

    /**
     * 跳转到预览模板页面
     * @return
     */
    @GetMapping("/previwTemp/{id}")
    @PreAuthorize("@ss.hasPermi('baseExportTemp:baseExportTemp:list')")
    public String previwTemp(@PathVariable Long id){
        BaseExportTemp baseExportTemp1 = baseExportTempService.selectBaseExportTempById(id);
        if(baseExportTemp1==null){
            throw new SecurityException("当前模板不存在");
        }
//        return "http://"+ IpUtils.getHostIp() +":"+environment.getProperty("server.port")+"/ureport/preview?_u="+baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName();
        return environment.getProperty("zehong.ureporturl")+"/ureport/preview?_u="+baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName();
    }
    /**
     * 实际业务--跳转到预览模板页面
     * @return
     */
    @GetMapping("/businessPreviwTemp")
    public String businessPreviwTemp(@Valid BaseTempExportDTO baseTempExportDTO){
        BaseExportTemp baseExportTemp1 = baseExportTempService.selectParamByCode(baseTempExportDTO.getCode());
        if(baseExportTemp1==null){
            throw new SecurityException("当前模板不存在");
        }
        String extraStr = "";
        if(StringUtils.isNotBlank(baseTempExportDTO.getOrderNo())){
            extraStr = extraStr+"&orderNo="+baseTempExportDTO.getOrderNo();
        }
        if(baseTempExportDTO.getExtraParams()!=null){
            String extraParams = baseTempExportDTO.getExtraParams().stream().collect(Collectors.joining(","));
            extraStr = extraStr+"&extraParams="+extraParams;
        }
//        return "http://"+ IpUtils.getHostIp() +":"
//                +environment.getProperty("server.port")+"/ureport/preview?_u="
//                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
//                +"&orderNo="+orderNo;
        //直接跳转到PDF预览页面
//        return "http://"+ IpUtils.getHostIp() +":"
//                +environment.getProperty("server.port")+"/ureport/pdf/show?_u="
//                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
//                +"&orderNo="+orderNo;
        return environment.getProperty("zehong.ureporturl")+"/ureport/pdf/show?_u="
                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
                +extraStr;
    }

    /**
     * 实际业务--导出excel
     * @return
     */
    @GetMapping("/businessExportExcel")
    public String businessExportExcel(@Valid BaseTempExportDTO baseTempExportDTO){
        BaseExportTemp baseExportTemp1 = baseExportTempService.selectParamByCode(baseTempExportDTO.getCode());
        if(baseExportTemp1==null){
            throw new SecurityException("当前模板不存在");
        }
//        return "http://"+ IpUtils.getHostIp() +":"
//                +environment.getProperty("server.port")+"/ureport/preview?_u="
//                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
//                +"&orderNo="+orderNo;
        //直接跳转到PDF预览页面
//        return "http://"+ IpUtils.getHostIp() +":"
//                +environment.getProperty("server.port")+"/ureport/excel?_u="
//                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
//                +"&orderNo="+orderNo;
        String extraStr = "";
        if(StringUtils.isNotBlank(baseTempExportDTO.getOrderNo())){
            extraStr = extraStr+"&orderNo="+baseTempExportDTO.getOrderNo();
        }
        if(baseTempExportDTO.getBeginTime()!=null){
            extraStr = extraStr+"&beginTime="+ DateUtils.parseDateToStr("yyyy-MM-dd HH:mm:ss",baseTempExportDTO.getBeginTime());
        }
        if(baseTempExportDTO.getEndTime()!=null){
            extraStr = extraStr+"&endTime="+ DateUtils.parseDateToStr("yyyy-MM-dd HH:mm:ss",baseTempExportDTO.getEndTime());
        }
        if(baseTempExportDTO.getExtraParams()!=null){
            String extraParams = baseTempExportDTO.getExtraParams().stream().collect(Collectors.joining(","));
            extraStr = extraStr+"&extraParams="+extraParams;
        }
        return environment.getProperty("zehong.ureporturl")+"/ureport/excel?_u="
                +baseExportTemp1.getPrefix()+baseExportTemp1.getTempFileName()
                +extraStr;
    }
}
