package com.zehong.common.exception;

import com.zehong.common.enums.ResultEnum;
import lombok.Getter;

@Getter
public class IOCException extends RuntimeException {

	private static final long serialVersionUID = 7272332822781740888L;
	
	private Integer code;
	
	public IOCException(ResultEnum resultEnum){
		super(resultEnum.getMessage());
		this.code = resultEnum.getCode();
	}
	
	public IOCException(Integer code, String message){
		super(message);
		this.code = code;
	}
}
