package com.zehong.web.controller.transferPostRecord;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTransferPostRecord;
import com.zehong.system.service.ITTransferPostRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 调岗记录Controller
 * 
 * @author zehong
 * @date 2023-09-21
 */
@RestController
@RequestMapping("/transferPost/record")
public class TTransferPostRecordController extends BaseController
{
    @Autowired
    private ITTransferPostRecordService tTransferPostRecordService;

    /**
     * 查询调岗记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTransferPostRecord tTransferPostRecord)
    {
        startPage();
        List<TTransferPostRecord> list = tTransferPostRecordService.selectTTransferPostRecordList(tTransferPostRecord);
        return getDataTable(list);
    }
    @GetMapping("/xiaolist")
    public TableDataInfo xiaolist(TTransferPostRecord tTransferPostRecord)
    {
        startPage();
        List<TTransferPostRecord> list = tTransferPostRecordService.xiaolist(tTransferPostRecord);
        return getDataTable(list);
    }

    /**
     * 导出调岗记录列表
     */
    @Log(title = "调岗记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTransferPostRecord tTransferPostRecord)
    {
        List<TTransferPostRecord> list = tTransferPostRecordService.selectTTransferPostRecordList(tTransferPostRecord);
        ExcelUtil<TTransferPostRecord> util = new ExcelUtil<TTransferPostRecord>(TTransferPostRecord.class);
        return util.exportExcel(list, "调岗记录数据");
    }

    /**
     * 获取调岗记录详细信息
     */
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(tTransferPostRecordService.selectTTransferPostRecordById(recordId));
    }

    /**
     * 新增调岗记录
     */
    @Log(title = "调岗记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTransferPostRecord tTransferPostRecord)
    {
        return toAjax(tTransferPostRecordService.insertTTransferPostRecord(tTransferPostRecord));
    }

    /**
     * 修改调岗记录
     */
    @Log(title = "调岗记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTransferPostRecord tTransferPostRecord)
    {
        return toAjax(tTransferPostRecordService.updateTTransferPostRecord(tTransferPostRecord));
    }

    /**
     * 删除调岗记录
     */
    @Log(title = "调岗记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(tTransferPostRecordService.deleteTTransferPostRecordByIds(recordIds));
    }
}
