package com.zehong.web.controller.thirdbuild;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TConGasProInc;
import com.zehong.system.service.ITConGasProIncService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 第三方施工-涉气第三方施工意外事件Controller
 * 
 * @author zehong
 * @date 2024-06-27
 */
@RestController
@RequestMapping("/third/accident")
public class TConGasProIncController extends BaseController
{
    @Autowired
    private ITConGasProIncService tConGasProIncService;

    /**
     * 查询第三方施工-涉气第三方施工意外事件列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TConGasProInc tConGasProInc)
    {
        startPage();
        List<TConGasProInc> list = tConGasProIncService.selectTConGasProIncList(tConGasProInc);
        return getDataTable(list);
    }

    /**
     * 导出第三方施工-涉气第三方施工意外事件列表
     */
    @Log(title = "第三方施工-涉气第三方施工意外事件", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TConGasProInc tConGasProInc)
    {
        List<TConGasProInc> list = tConGasProIncService.exportTConGasProIncList(tConGasProInc);
        ExcelUtil<TConGasProInc> util = new ExcelUtil<TConGasProInc>(TConGasProInc.class);
        AjaxResult ajaxResult = util.exportExcel(list, "第三方施工-涉气第三方施工意外事件数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取第三方施工-涉气第三方施工意外事件详细信息
     */
    @GetMapping(value = "/{fConGasProIncId}")
    public AjaxResult getInfo(@PathVariable("fConGasProIncId") Long fConGasProIncId)
    {
        return AjaxResult.success(tConGasProIncService.selectTConGasProIncById(fConGasProIncId));
    }

    /**
     * 新增第三方施工-涉气第三方施工意外事件
     */
    @Log(title = "第三方施工-涉气第三方施工意外事件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TConGasProInc tConGasProInc)
    {
        return toAjax(tConGasProIncService.insertTConGasProInc(tConGasProInc));
    }

    /**
     * 修改第三方施工-涉气第三方施工意外事件
     */
    @Log(title = "第三方施工-涉气第三方施工意外事件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TConGasProInc tConGasProInc)
    {
        return toAjax(tConGasProIncService.updateTConGasProInc(tConGasProInc));
    }

    /**
     * 删除第三方施工-涉气第三方施工意外事件
     */
    @Log(title = "第三方施工-涉气第三方施工意外事件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fConGasProIncIds}")
    public AjaxResult remove(@PathVariable Long[] fConGasProIncIds)
    {
        return toAjax(tConGasProIncService.deleteTConGasProIncByIds(fConGasProIncIds));
    }

    /**
     * 上传第三方施工意外事件
     * @param fConGasProIncId 意外事件工id
     * @return
     */
    @GetMapping("/reportAccidentInfo")
    public AjaxResult reportAccidentInfo(Long fConGasProIncId){
        try{
            return toAjax(tConGasProIncService.reportAccidentInfo(fConGasProIncId));
        }catch (Exception e){
            logger.error("上传第三方施意外事件工接口异常=====",e);
            return AjaxResult.error("上传第三方施工意外事件接口异常");
        }
    }


    /**
     * 企业端上传第三方施工意外事件
     * @param fConGasProIncId 第三方施工意外事件id
     * @return
     */
    @GetMapping("/entReportConGasProInfo")
    public AjaxResult entReportConGasProInfo(Long fConGasProIncId){
        return toAjax(tConGasProIncService.entReportConGasProInfo(fConGasProIncId));
    }
}
