package com.zehong.web.controller.task;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkTaskPatrol;
import com.zehong.system.service.ITWorkTaskPatrolService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡线任务Controller
 * 
 * @author zehong
 * @date 2023-09-15
 */
@RestController
@RequestMapping("/system/patrol")
public class TWorkTaskPatrolController extends BaseController
{
    @Autowired
    private ITWorkTaskPatrolService tWorkTaskPatrolService;

    /**
     * 查询巡线任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkTaskPatrol tWorkTaskPatrol)
    {
        startPage();
        List<TWorkTaskPatrol> list = tWorkTaskPatrolService.selectTWorkTaskPatrolList(tWorkTaskPatrol);
        return getDataTable(list);
    }

    /**
     * 导出巡线任务列表
     */
    @Log(title = "巡线任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkTaskPatrol tWorkTaskPatrol)
    {
        List<TWorkTaskPatrol> list = tWorkTaskPatrolService.selectTWorkTaskPatrolList(tWorkTaskPatrol);
        ExcelUtil<TWorkTaskPatrol> util = new ExcelUtil<TWorkTaskPatrol>(TWorkTaskPatrol.class);
        return util.exportExcel(list, "巡线任务数据");
    }

    /**
     * 获取巡线任务详细信息
     */
    @GetMapping(value = "/{patrolId}")
    public AjaxResult getInfo(@PathVariable("patrolId") Long patrolId)
    {
        return AjaxResult.success(tWorkTaskPatrolService.selectTWorkTaskPatrolById(patrolId));
    }

    /**
     * 新增巡线任务
     */
    @Log(title = "巡线任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkTaskPatrol tWorkTaskPatrol)
    {
        int a = tWorkTaskPatrolService.insertTWorkTaskPatrol(tWorkTaskPatrol);
        return AjaxResult.success(tWorkTaskPatrol);
    }

    @Log(title = "巡线任务", businessType = BusinessType.UPDATE)
    @PutMapping(value = "/updatebytmid")
    public AjaxResult updatebytmid(@RequestBody TWorkTaskPatrol tWorkTaskPatrol)
    {
        int a = tWorkTaskPatrolService.updatebytmid(tWorkTaskPatrol);
        return AjaxResult.success(tWorkTaskPatrol);
    }
    /**
     * 修改巡线任务
     */
    @Log(title = "巡线任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkTaskPatrol tWorkTaskPatrol)
    {
        return toAjax(tWorkTaskPatrolService.updateTWorkTaskPatrol(tWorkTaskPatrol));
    }

    /**
     * 删除巡线任务
     */
    @Log(title = "巡线任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{patrolIds}")
    public AjaxResult remove(@PathVariable Long[] patrolIds)
    {
        return toAjax(tWorkTaskPatrolService.deleteTWorkTaskPatrolByIds(patrolIds));
    }

    /**
     * 巡检统计
     * @param tWorkTaskPatrol 巡检实体
     * @return
     */
    @GetMapping("/patrolStatistic")
    public AjaxResult patrolStatistic(TWorkTaskPatrol tWorkTaskPatrol){
        return AjaxResult.success(tWorkTaskPatrolService.patrolStatistic(tWorkTaskPatrol));
    }
}
