package com.zehong.web.controller.task;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectionAccident;
import com.zehong.system.service.ITInspectionAccidentService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检事故Controller
 *
 * @author zehong
 * @date 2026-02-02
 */
@RestController
@RequestMapping("/system/accident")
public class TInspectionAccidentController extends BaseController
{
    @Autowired
    private ITInspectionAccidentService tInspectionAccidentService;

    /**
     * 查询巡检事故列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInspectionAccident tInspectionAccident)
    {
        startPage();
        List<TInspectionAccident> list = tInspectionAccidentService.selectTInspectionAccidentList(tInspectionAccident);
        return getDataTable(list);
    }

    /**
     * 导出巡检事故列表
     */
    @Log(title = "巡检事故", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectionAccident tInspectionAccident)
    {
        List<TInspectionAccident> list = tInspectionAccidentService.selectTInspectionAccidentList(tInspectionAccident);
        ExcelUtil<TInspectionAccident> util = new ExcelUtil<TInspectionAccident>(TInspectionAccident.class);
        return util.exportExcel(list, "巡检事故数据");
    }

    /**
     * 获取巡检事故详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tInspectionAccidentService.selectTInspectionAccidentById(id));
    }

    /**
     * 新增巡检事故
     */
    @Log(title = "巡检事故", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectionAccident tInspectionAccident)
    {
        return toAjax(tInspectionAccidentService.insertTInspectionAccident(tInspectionAccident));
    }

    /**
     * 修改巡检事故
     */
    @Log(title = "巡检事故", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectionAccident tInspectionAccident)
    {
        return toAjax(tInspectionAccidentService.updateTInspectionAccident(tInspectionAccident));
    }

    /**
     * 删除巡检事故
     */
    @Log(title = "巡检事故", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tInspectionAccidentService.deleteTInspectionAccidentByIds(ids));
    }
}