package com.zehong.web.controller.system;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.*;
import com.zehong.system.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * 配送记录Controller
 *
 * @author zehong
 * @date 2023-08-22
 */
@RestController
@RequestMapping("/system/recordn")
public class TDeliveryRecordController extends BaseController
{
    @Autowired
    private ITDeliveryRecordService tDeliveryRecordService;

    @Autowired
    private ITGasBottleInfoService tGasBottleInfoService;
    @Autowired
    private ITGasUserInfoService tGasUserInfoService;
    @Autowired
    private ITGasBottleTrackRecordService tGasBottleTrackRecordService;
    @Autowired
    private ITTaskRecordService tTaskRecordService;


    /**
     * 查询配送记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDeliveryRecord tDeliveryRecord)
    {
        startPage();
        List<TDeliveryRecord> list = tDeliveryRecordService.selectTDeliveryRecordList(tDeliveryRecord);
        return getDataTable(list);
    }

    /**
     * 导出配送记录列表
     */
    @Log(title = "配送记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeliveryRecord tDeliveryRecord)
    {
        List<TDeliveryRecord> list = tDeliveryRecordService.selectTDeliveryRecordList(tDeliveryRecord);
        ExcelUtil<TDeliveryRecord> util = new ExcelUtil<TDeliveryRecord>(TDeliveryRecord.class);
        return util.exportExcel(list, "配送记录数据");
    }

    /**
     * 获取配送记录详细信息
     */
    @GetMapping(value = "/{deliveryRecordId}")
    public AjaxResult getInfo(@PathVariable("deliveryRecordId") Long deliveryRecordId)
    {
        return AjaxResult.success(tDeliveryRecordService.selectTDeliveryRecordById(deliveryRecordId));
    }


    /**
     * 微信小程序获取配送记录详细信息
     * @param deliveryRecordId
     * @return
     */
    @GetMapping("/getInfos")
    public AjaxResult getInfos(Long deliveryRecordId)
    {
        TDeliveryRecord tDeliveryRecord = tDeliveryRecordService.selectTDeliveryRecordById(deliveryRecordId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tAirChargeRecord", tDeliveryRecord);
        return ajax;
    }



    /**
     * 新增配送记录
     */
    @Log(title = "配送记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeliveryRecord tDeliveryRecord)
    {
        return toAjax(tDeliveryRecordService.insertTDeliveryRecord(tDeliveryRecord));
    }

    /**
     * 新增配送记录
     * @param tDeliveryRecord
     * @return
     */
    @PostMapping("/addRecord")
    public int addRecord(@RequestBody TDeliveryRecord tDeliveryRecord)
    {
        TGasBottleInfo tGasBottleInfo1 = tGasBottleInfoService.selectTGasBottleInfoById(tDeliveryRecord.getBottleId());
        if ("1".equals(tGasBottleInfo1.getCurrentStatus())){
            return 1;
        }
        if ("0".equals(tGasBottleInfo1.getEmptyType())){
            return 2;
        }
        TGasBottleInfo tGasBottleInfo=new TGasBottleInfo();
        tGasBottleInfo.setBottleId(tDeliveryRecord.getBottleId());
        //修改气瓶状态为离站状态
        tGasBottleInfo.setCurrentStatus("1");
        //修改气瓶信息
        tGasBottleInfoService.updateTGasBottleInfo(tGasBottleInfo);
        //设置配送时间
        tDeliveryRecord.setDeliveryDate(new Date());
        //设置燃气用户末次配送时间
        TGasUserInfo tGasUserInfo=new TGasUserInfo();
        tGasUserInfo.setGasUserId(tDeliveryRecord.getGasUserId());
        tGasUserInfo.setLastDeliveryDate(new Date());
        tGasUserInfoService.updateTGasUserInfo(tGasUserInfo);
        //气瓶追溯信息添加
        TGasBottleTrackRecord tGasBottleTrackRecord=new TGasBottleTrackRecord();
        //储配站主键
        tGasBottleTrackRecord.setStationId(tDeliveryRecord.getStationId());
        //储配站
        tGasBottleTrackRecord.setStationName(tDeliveryRecord.getStationName());
        //气瓶主键
        tGasBottleTrackRecord.setBottleId(tDeliveryRecord.getBottleId());
        //气瓶条码
        tGasBottleTrackRecord.setBottleCode(tDeliveryRecord.getBottleCode());
        //工序 气瓶配送
        tGasBottleTrackRecord.setProcessesName("1");
        //配送人员
        tGasBottleTrackRecord.setSender(tDeliveryRecord.getDeliveryPerson());
        tGasBottleTrackRecord.setOperator(Long.valueOf(tDeliveryRecord.getDeliveryPerson()));

        //接收人员
        tGasBottleTrackRecord.setRecipient(String.valueOf(tDeliveryRecord.getGasUserId()));
        tGasBottleTrackRecord.setOperateDate(new Date());
        tDeliveryRecordService.insertTDeliveryRecord(tDeliveryRecord);
        tGasBottleTrackRecord.setOperatorName(tDeliveryRecord.getDeliveryPersonName());

        //气瓶追溯表信息添加
        tGasBottleTrackRecord.setProcessesRelationId(tDeliveryRecord.getDeliveryRecordId());
        tGasBottleTrackRecordService.insertTGasBottleTrackRecord(tGasBottleTrackRecord);
        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(Long.valueOf(tDeliveryRecord.getDeliveryPerson()));
        //工序
        tTaskRecord.setProcessesName("1");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tDeliveryRecord.getDeliveryRecordId());
        //任务记录表信息添加
        tTaskRecordService.insertTTaskRecord(tTaskRecord);
        return 0;
    }


    /**
     * 修改配送记录
     */
    @Log(title = "配送记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeliveryRecord tDeliveryRecord)
    {
        return toAjax(tDeliveryRecordService.updateTDeliveryRecord(tDeliveryRecord));
    }

    /**
     * 删除配送记录
     */
    @Log(title = "配送记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deliveryRecordIds}")
    public AjaxResult remove(@PathVariable Long[] deliveryRecordIds)
    {
        return toAjax(tDeliveryRecordService.deleteTDeliveryRecordByIds(deliveryRecordIds));
    }
}
