package com.zehong.web.controller.supplybalance;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupBalStopSupOprPressLog;
import com.zehong.system.service.ITSupBalStopSupOprPressLogService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 供需平衡-停气监管-停气进度操作历史记录Controller
 * 
 * @author zehong
 * @date 2024-07-16
 */
@RestController
@RequestMapping("/supplyBalance/stopLog")
public class TSupBalStopSupOprPressLogController extends BaseController
{
    @Autowired
    private ITSupBalStopSupOprPressLogService tSupBalStopSupOprPressLogService;

    /**
     * 查询供需平衡-停气监管-停气进度操作历史记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        startPage();
        List<TSupBalStopSupOprPressLog> list = tSupBalStopSupOprPressLogService.selectTSupBalStopSupOprPressLogList(tSupBalStopSupOprPressLog);
        return getDataTable(list);
    }

    /**
     * 导出供需平衡-停气监管-停气进度操作历史记录列表
     */
    @Log(title = "供需平衡-停气监管-停气进度操作历史记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        List<TSupBalStopSupOprPressLog> list = tSupBalStopSupOprPressLogService.selectTSupBalStopSupOprPressLogList(tSupBalStopSupOprPressLog);
        ExcelUtil<TSupBalStopSupOprPressLog> util = new ExcelUtil<TSupBalStopSupOprPressLog>(TSupBalStopSupOprPressLog.class);
        return util.exportExcel(list, "供需平衡-停气监管-停气进度操作历史记录数据");
    }

    /**
     * 获取供需平衡-停气监管-停气进度操作历史记录详细信息
     */
    @GetMapping(value = "/{fOprPressLogId}")
    public AjaxResult getInfo(@PathVariable("fOprPressLogId") Long fOprPressLogId)
    {
        return AjaxResult.success(tSupBalStopSupOprPressLogService.selectTSupBalStopSupOprPressLogById(fOprPressLogId));
    }

    /**
     * 新增供需平衡-停气监管-停气进度操作历史记录
     */
    @Log(title = "供需平衡-停气监管-停气进度操作历史记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        return toAjax(tSupBalStopSupOprPressLogService.insertTSupBalStopSupOprPressLog(tSupBalStopSupOprPressLog));
    }

    /**
     * 修改供需平衡-停气监管-停气进度操作历史记录
     */
    @Log(title = "供需平衡-停气监管-停气进度操作历史记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        return toAjax(tSupBalStopSupOprPressLogService.updateTSupBalStopSupOprPressLog(tSupBalStopSupOprPressLog));
    }

    /**
     * 删除供需平衡-停气监管-停气进度操作历史记录
     */
    @Log(title = "供需平衡-停气监管-停气进度操作历史记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fOprPressLogIds}")
    public AjaxResult remove(@PathVariable Long[] fOprPressLogIds)
    {
        return toAjax(tSupBalStopSupOprPressLogService.deleteTSupBalStopSupOprPressLogByIds(fOprPressLogIds));
    }
}
