package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsSpotRecInfor;
import com.zehong.system.service.ITInsSpotRecInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-调查结果Controller
 * 
 * @author zehong
 * @date 2024-05-22
 */
@RestController
@RequestMapping("/supervision/findings")
public class TInsSpotRecInforController extends BaseController
{
    @Autowired
    private ITInsSpotRecInforService tInsSpotRecInforService;

    /**
     * 查询监督检查-调查结果列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsSpotRecInfor tInsSpotRecInfor)
    {
        startPage();
        List<TInsSpotRecInfor> list = tInsSpotRecInforService.selectTInsSpotRecInforList(tInsSpotRecInfor);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-调查结果列表
     */
    @Log(title = "监督检查-调查结果", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsSpotRecInfor tInsSpotRecInfor)
    {
        List<TInsSpotRecInfor> list = tInsSpotRecInforService.selectTInsSpotRecInforList(tInsSpotRecInfor);
        ExcelUtil<TInsSpotRecInfor> util = new ExcelUtil<TInsSpotRecInfor>(TInsSpotRecInfor.class);
        return util.exportExcel(list, "监督检查-调查结果数据");
    }

    /**
     * 获取监督检查-调查结果详细信息
     */
    @GetMapping(value = "/{fInsSpotRecInforId}")
    public AjaxResult getInfo(@PathVariable("fInsSpotRecInforId") Long fInsSpotRecInforId)
    {
        return AjaxResult.success(tInsSpotRecInforService.selectTInsSpotRecInforById(fInsSpotRecInforId));
    }

    /**
     * 新增监督检查-调查结果
     */
    @Log(title = "监督检查-调查结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsSpotRecInfor tInsSpotRecInfor)
    {
        return toAjax(tInsSpotRecInforService.insertTInsSpotRecInfor(tInsSpotRecInfor));
    }

    /**
     * 修改监督检查-调查结果
     */
    @Log(title = "监督检查-调查结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsSpotRecInfor tInsSpotRecInfor)
    {
        return toAjax(tInsSpotRecInforService.updateTInsSpotRecInfor(tInsSpotRecInfor));
    }

    /**
     * 删除监督检查-调查结果
     */
    @Log(title = "监督检查-调查结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsSpotRecInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsSpotRecInforIds)
    {
        return toAjax(tInsSpotRecInforService.deleteTInsSpotRecInforByIds(fInsSpotRecInforIds));
    }

    /**
     * 上传调查结果
     * @param fInsSpotRecInforId 调查结果id
     * @return
     */
    @GetMapping("/reportSpotRecInfo")
    public AjaxResult reportSpotRecInfo(Long fInsSpotRecInforId){
        try{
            return toAjax(tInsSpotRecInforService.reportSpotRecInfo(fInsSpotRecInforId));
        }catch (Exception e){
            logger.error("上传调查结果接口异常=====",e);
            return AjaxResult.error("上传调查结果接口异常");
        }
    }
}
