package com.zehong.web.controller.supervise;
import java.io.File;
import java.text.ParseException;
import java.util.List;
import com.zehong.common.config.GassafetyProgressConfig;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TProjectInfo;
import com.zehong.system.service.ITProjectInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 工程项目信息Controller
 *
 * @author zehong
 * @date 2022-03-16
 */
@RestController
@RequestMapping("/project/info")
public class TProjectInfoController extends BaseController
{
    @Autowired
    private ITProjectInfoService tProjectInfoService;

    /**
     * 查询工程项目信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TProjectInfo tProjectInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tProjectInfo.setBeyondEnterpriseId(user.getDeptId());
        startPage();
        List<TProjectInfo> list = tProjectInfoService.selectTProjectInfoList(tProjectInfo);
        return getDataTable(list);
    }

    /**
     * 导出工程项目信息列表
     */
    @Log(title = "工程项目信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TProjectInfo tProjectInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tProjectInfo.setBeyondEnterpriseId(user.getDeptId());
        List<TProjectInfo> list = tProjectInfoService.selectTProjectInfoList(tProjectInfo);
        ExcelUtil<TProjectInfo> util = new ExcelUtil<TProjectInfo>(TProjectInfo.class);
        return util.exportExcel(list, "工程项目信息数据");
    }

    /**
     * 获取工程项目信息详细信息
     */
    @GetMapping(value = "/{projectId}")
    public AjaxResult getInfo(@PathVariable("projectId") Long projectId)
    {
        return AjaxResult.success(tProjectInfoService.selectTProjectInfoById(projectId));
    }

    /**
     * 新增工程项目信息
     */
    @Log(title = "工程项目信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TProjectInfo tProjectInfo) throws ParseException {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tProjectInfo.setBeyondEnterpriseId(user.getDeptId());
        //查询是否已经有重复的年份数据
        List<TProjectInfo> tProjectInfos = tProjectInfoService.selectSameYear(tProjectInfo.getProjectYear(),tProjectInfo.getBeyondEnterpriseId());
        //说明有重复的年份 将重复的年份删除
        if (tProjectInfos.size()!=0){
            //重复年份删除方法
            tProjectInfoService.deleteisSameYear(tProjectInfo.getProjectYear(),tProjectInfo.getBeyondEnterpriseId());
        }
        if (!"-2".equals(user.getDeptId())){
            //查询企业名称
            String enterpriseName = tProjectInfoService.selectEnterpriseName(user.getDeptId());
            tProjectInfo.setEnterpriseCode(String.valueOf(enterpriseName));
        }else {
            tProjectInfo.setEnterpriseCode("政府部门");
        }
        //添加企业
        tProjectInfo.setBeyondEnterpriseId(user.getDeptId());
        return toAjax(tProjectInfoService.insertTProjectInfo(tProjectInfo));
    }

    /**
     * 修改工程项目信息
     */
    @Log(title = "工程项目信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TProjectInfo tProjectInfo)
    {
        //查询修改文件之前的路径
        TProjectInfo tProjectInfos = tProjectInfoService.selectNearbyAddress(tProjectInfo.getProjectId());
        if (tProjectInfos!=null){
            // 上传文件路径
            String filePath = GassafetyProgressConfig.getUploadPath();
            String[] strs = tProjectInfos.getNearbyAddress().split("upload");
            //删除
            File file = new File(filePath+strs[1].toString());
            // 上传文件路径
            if(file.isFile()){
                file.delete();
            }
        }
        return toAjax(tProjectInfoService.updateTProjectInfo(tProjectInfo));
    }

    /**
     * 删除工程项目信息
     */
    @Log(title = "工程项目信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{projectIds}")
    public AjaxResult remove(@PathVariable Long[] projectIds)
    {
        return toAjax(tProjectInfoService.deleteTProjectInfoByIds(projectIds));
    }

    @GetMapping(value = "/selectNum")
    public AjaxResult selectNum()
    {
        return AjaxResult.success(tProjectInfoService.selectNum());
    }


}
