package com.zehong.web.controller.supervise;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.THiddenTroubleInfo;
import com.zehong.system.service.ITHiddenDangerStandingBookService;
import com.zehong.system.service.ITHiddenTroubleInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 燃气隐患Controller
 *
 * @author zehong
 * @date 2022-03-31
 */
@RestController
@RequestMapping("/system/info")
public class THiddenTroubleInfoSController extends BaseController
{
    private static final Logger log = LoggerFactory.getLogger(THiddenTroubleInfoSController.class);
    @Autowired
    private ITHiddenTroubleInfoService tHiddenTroubleInfoService;
    @Autowired
    private ITHiddenDangerStandingBookService tHiddenDangerStandingBookService;

    /**
     * 查询燃气隐患列表
     */
    @GetMapping("/list")
    public TableDataInfo list(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if(tHiddenTroubleInfo.getBeyondEnterpriseId()==null){
            tHiddenTroubleInfo.setBeyondEnterpriseId(user.getDeptId());
        }
        if(isGovernment()){
            tHiddenTroubleInfo.setIsReport(1);
        }
        startPage();
        List<THiddenTroubleInfo> list = tHiddenTroubleInfoService.selectTHiddenTroubleInfoList(tHiddenTroubleInfo);
        return getDataTable(list);
    }
    @GetMapping("/listCount")
    public AjaxResult listCount(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tHiddenTroubleInfo.setBeyondEnterpriseId(user.getDeptId());
        List<Map<String,Object>> list = tHiddenTroubleInfoService.selectTHiddenTroubleInfoListCount(tHiddenTroubleInfo);
        return AjaxResult.success(list);
    }


    /**
     * 导出燃气隐患列表
     */
    @Log(title = "燃气隐患", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenTroubleInfo tHiddenTroubleInfo)
    {
        List<THiddenTroubleInfo> list = tHiddenTroubleInfoService.selectTHiddenTroubleInfoExcelList(tHiddenTroubleInfo);
        ExcelUtil<THiddenTroubleInfo> util = new ExcelUtil<THiddenTroubleInfo>(THiddenTroubleInfo.class);
        return util.exportExcel(list, "燃气隐患数据");
    }

    /**
     * 获取燃气隐患详细信息
     */
    @GetMapping(value = "/{hiddenTroubleId}")
    public AjaxResult getInfo(@PathVariable("hiddenTroubleId") Long hiddenTroubleId)
    {
        System.out.println(tHiddenTroubleInfoService.selectTHiddenTroubleInfoById(hiddenTroubleId));
        return AjaxResult.success(tHiddenTroubleInfoService.selectTHiddenTroubleInfoById(hiddenTroubleId));
    }

    /**
     * 新增燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenTroubleInfo tHiddenTroubleInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if(tHiddenTroubleInfo.getBeyondEnterpriseId()==null){
            tHiddenTroubleInfo.setBeyondEnterpriseId(user.getDeptId());
        }
        tHiddenTroubleInfo.setReportPerson(user.getNickName());
        SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
        tHiddenTroubleInfo.setReportTime(dateTime.format(new Date()));
        if(isGovernment()){
            tHiddenTroubleInfo.setIsReport(1);
        }
        /*隐患整治台账添加*/
        //THiddenDangerStandingBook tHiddenDangerStandingBook=new THiddenDangerStandingBook();
        //隐患名称
//        tHiddenDangerStandingBook.setHiddenTitle(tHiddenTroubleInfo.getHiddenTroubleName());
//        //隐患等级
//        tHiddenDangerStandingBook.setHiddenType(tHiddenTroubleInfo.getHiddenTroubleLevel());
//        /*隐患位置*/
////        tHiddenDangerStandingBook.setHiddenLocation();
//        /*隐患发现人员*/
//        tHiddenDangerStandingBook.setHiddenFindPeople(user.getNickName());
//        /*经度   纬度*/
//        tHiddenDangerStandingBook.setLongitude(tHiddenTroubleInfo.getLongitude());
//        tHiddenDangerStandingBook.setLatitude(tHiddenTroubleInfo.getLatitude());
//        tHiddenDangerStandingBook.setRemediation(tHiddenTroubleInfo.getHiddenTroubleDealStatus());
//        tHiddenDangerStandingBook.setRemarks(tHiddenTroubleInfo.getRemarks());
//        tHiddenDangerStandingBook.setHiddenFindDate(new Date());
//        tHiddenDangerStandingBookService.insertTHiddenDangerStandingBook(tHiddenDangerStandingBook);
        return toAjax(tHiddenTroubleInfoService.insertTHiddenTroubleInfo(tHiddenTroubleInfo));
    }

    /**
     * 修改燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenTroubleInfo tHiddenTroubleInfo)
    {
        //查询燃气信息是否有修改 如果有值证明没有修改  如果没有值证明已经修改
        THiddenTroubleInfo tHiddenTroubleInfo1 = tHiddenTroubleInfoService.selectDetails(tHiddenTroubleInfo);
        if (tHiddenTroubleInfo1==null){
            tHiddenTroubleInfo.setHiddenTroubleDealStatus("1");
        }
        return toAjax(tHiddenTroubleInfoService.updateTHiddenTroubleInfo(tHiddenTroubleInfo));
    }

    /**
     * 删除燃气隐患
     */
    @Log(title = "燃气隐患", businessType = BusinessType.DELETE)
	@DeleteMapping("/{hiddenTroubleIds}")
    public AjaxResult remove(@PathVariable Long[] hiddenTroubleIds)
    {
        return toAjax(tHiddenTroubleInfoService.deleteTHiddenTroubleInfoByIds(hiddenTroubleIds));
    }

    /**
     * 判断是否为政府角色
     * @return
     */
    private boolean isGovernment(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("gov");
    }

    /**
     *上报
     * @return
     */
    @GetMapping("/reportGovernment")
    public AjaxResult reportGovernment(THiddenTroubleInfo tHiddenTroubleInfo){
        try {
            return toAjax(tHiddenTroubleInfoService.reportGovernment(tHiddenTroubleInfo));
        } catch (Exception e) {
            log.error("隐患上报错误：",e);
            return AjaxResult.error("隐患上报错误");
        }
    }
}
