package com.zehong.web.controller.statistic;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.domain.TVideoManager;
import com.zehong.system.domain.form.THiddenDangerStandingBookForm;
import com.zehong.system.domain.vo.HomepageVo;
import com.zehong.system.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 统计分析
 * 
 * @author zehong
 */
@RestController
@RequestMapping("/statistic")
public class StatisticController
{
    private static final Logger log = LoggerFactory.getLogger(StatisticController.class);

    @Autowired
    private ITVideoManagerService tVideoManagerService;
    @Autowired
    private ITSafeEquipmentStandingBookService tSafeEquipmentStandingBookService;
    @Autowired
    private ITTroubleStandingBookService tTroubleStandingBookService;
    @Autowired
    private ITHiddenDangerStandingBookService tHiddenDangerStandingBookService;
    @Autowired
    private ITComplainDealService tComplainDealService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private ITWorkOrderService tWorkOrderService;

    /**
     * 燃气事故台账统计
     */
    @GetMapping("/troubleStatistic")
    public AjaxResult troubleStatistic()
    {
        return AjaxResult.success(tTroubleStandingBookService.selectTTroubleStandingBookStatistic());
    }

    /**
     * 隐患整治台账统计
     */
    @GetMapping("/hiddenStatistic")
    public AjaxResult hiddenStatistic()
    {
        return AjaxResult.success(tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookStatistic());
    }

    /**
     * 首页统计
     */
    @GetMapping("/homepageStatistic")
    public AjaxResult homepageStatistic()
    {
        HomepageVo homepageVo = new HomepageVo();
        //获取当前登录用户信息
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();

        homepageVo = tComplainDealService.countTComplainDeal();
        /*homepageVo.setTaskTotal(itVehicleInfoService.countCar(user.getDeptId()));
        homepageVo.setTaskFeedbackTotal(0);*/
        HomepageVo info = tWorkOrderService.countTWorkOrder();
        homepageVo.setTaskTotal(info.getTaskTotal());
        homepageVo.setTaskFeedbackTotal(info.getTaskFeedbackTotal());

        List<TVideoManager> tVideoManagerList = tVideoManagerService.selectTVideoManagerList(null);
        List<TSafeEquipmentStandingBook> tSafeEquipmentStandingBookList = tSafeEquipmentStandingBookService.selectTSafeEquipmentStandingBookList(null);
        List<TTroubleStandingBook> tTroubleStandingBookList = tTroubleStandingBookService.selectTTroubleStandingBookList(null);
        THiddenDangerStandingBookForm tHiddenDangerStandingBook = new THiddenDangerStandingBookForm();
        if(!SecurityUtils.isAdmin(SecurityUtils.getLoginUser().getUser().getUserId())){
            tHiddenDangerStandingBook.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        List<THiddenDangerStandingBook> tHiddenDangerStandingBookList = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);

        homepageVo.setVideoTotal(tVideoManagerList.size());
        homepageVo.setEquipmentTotal(tSafeEquipmentStandingBookList.size());
        homepageVo.setTroubleTotal(tTroubleStandingBookList.size());
        homepageVo.setHiddenTotal(tHiddenDangerStandingBookList.size());

        return AjaxResult.success(homepageVo);
    }

}
