package com.zehong.web.controller.standingBook;

import java.util.ArrayList;
import java.util.List;

import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.form.TTroubleStandingBookForm;
import com.zehong.web.controller.tool.TimeConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.service.ITTroubleStandingBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事故台账Controller
 *
 * @author zehong
 * @date 2022-02-09
 */
@RestController
@RequestMapping("/standingBook/trouble")
public class TTroubleStandingBookController extends BaseController
{
    @Autowired
    private ITTroubleStandingBookService tTroubleStandingBookService;

    /**
     * 查询事故台账列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTroubleStandingBookForm tTroubleStandingBook)
    {
        startPage();
        List<TTroubleStandingBook> list = tTroubleStandingBookService.selectTTroubleStandingBookList(tTroubleStandingBook);
        return getDataTable(list);
    }

    /**
     * 统计每个月事故数量
     * @return
     */
    @GetMapping("/selectTrobleCountByMonth")
    public AjaxResult selectTrobleCountByMonth() {
        return AjaxResult.success(tTroubleStandingBookService.selectTrobleCountByMonth());
    }
    /**
     * 统计每年事故数量
     * @return
     */
    @GetMapping("/selectTrobleCountByYear")
    public AjaxResult selectTrobleCountByYear() {
        return AjaxResult.success(tTroubleStandingBookService.selectTrobleCountByYear());
    }
    /**
     * 统计乡镇事故数量
     * @return
     */
    @GetMapping("/selectTrobleRanking")
    public AjaxResult selectTrobleRanking() {
        return AjaxResult.success(tTroubleStandingBookService.selectTrobleRanking());
    }
    /**
     * 根据事故原因统计数量
     * @return
     */
    @GetMapping("/selectTrobleReason")
    public AjaxResult selectTrobleReason() {
        return AjaxResult.success(tTroubleStandingBookService.selectTrobleReason());
    }

    /**
     * 获取事故台账统计
     */
    @GetMapping("/accidentLedger")
    public AjaxResult accidentLedger()
    {
        List<Statistics> list=new ArrayList<>();
        //查询统计日期和数量
        List<Statistics> statistics = tTroubleStandingBookService.accidentLedger(TimeConfig.getSevenDate());
        //生成近7天数据
        List<String> sevenDate = TimeConfig.getSevenDate();
        if (statistics.size()==0){
            for (int n=0;n<7;n++){
                Statistics statisticsn=new Statistics();
                statisticsn.setCount(0);
                statisticsn.setDate(sevenDate.get(n));
                list.add(statisticsn);
            }
        }
        for (int s=0;s<statistics.size();s++){
            for (int i=0;i<sevenDate.size();i++){
                Statistics statistics1=new Statistics();
                if (statistics.get(s).getDate().equals(sevenDate.get(i))){
                    statistics1.setCount(statistics.get(s).getCount());
                    statistics1.setDate(sevenDate.get(i));
                    list.add(statistics1);
                }else {
                    statistics1.setCount(0);
                    statistics1.setDate(sevenDate.get(i));
                    list.add(statistics1);
                }
            }
        }

        return AjaxResult.success(list);
    }

    /**
     * 导出事故台账列表
     */
    @Log(title = "事故台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTroubleStandingBookForm tTroubleStandingBook)
    {
        List<TTroubleStandingBook> list = tTroubleStandingBookService.selectTTroubleStandingBookList(tTroubleStandingBook);
        ExcelUtil<TTroubleStandingBook> util = new ExcelUtil<TTroubleStandingBook>(TTroubleStandingBook.class);
        return util.exportExcel(list, "事故台账数据");
    }

    /**
     * 获取事故台账详细信息
     */
    @GetMapping(value = "/{troubleId}")
    public AjaxResult getInfo(@PathVariable("troubleId") Long troubleId)
    {
        return AjaxResult.success(tTroubleStandingBookService.selectTTroubleStandingBookById(troubleId));
    }

    /**
     * 新增事故台账
     */
    @Log(title = "事故台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTroubleStandingBook tTroubleStandingBook)
    {
        return toAjax(tTroubleStandingBookService.insertTTroubleStandingBook(tTroubleStandingBook));
    }

    /**
     * 修改事故台账
     */
    @Log(title = "事故台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTroubleStandingBook tTroubleStandingBook)
    {
        return toAjax(tTroubleStandingBookService.updateTTroubleStandingBook(tTroubleStandingBook));
    }

    /**
     * 删除事故台账
     */
    @Log(title = "事故台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{troubleIds}")
    public AjaxResult remove(@PathVariable Long[] troubleIds)
    {
        return toAjax(tTroubleStandingBookService.deleteTTroubleStandingBookByIds(troubleIds));
    }
}
