package com.zehong.web.controller.specialist;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.FProBehInforBrowse;
import com.zehong.system.service.IFProBehInforBrowseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 行业专家库-专家行为浏览Controller
 * 
 * @author zehong
 * @date 2024-05-09
 */
@RestController
@RequestMapping("/specialist/behBrowse")
public class FProBehInforBrowseController extends BaseController
{
    @Autowired
    private IFProBehInforBrowseService fProBehInforBrowseService;

    /**
     * 查询行业专家库-专家行为浏览列表
     */
    @GetMapping("/list")
    public TableDataInfo list(FProBehInforBrowse fProBehInforBrowse)
    {
        startPage();
        List<FProBehInforBrowse> list = fProBehInforBrowseService.selectFProBehInforBrowseList(fProBehInforBrowse);
        return getDataTable(list);
    }

    /**
     * 导出行业专家库-专家行为浏览列表
     */
    @Log(title = "行业专家库-专家行为浏览", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(FProBehInforBrowse fProBehInforBrowse)
    {
        List<FProBehInforBrowse> list = fProBehInforBrowseService.selectFProBehInforBrowseList(fProBehInforBrowse);
        ExcelUtil<FProBehInforBrowse> util = new ExcelUtil<FProBehInforBrowse>(FProBehInforBrowse.class);
        return util.exportExcel(list, "行业专家库-专家行为浏览数据");
    }

    /**
     * 获取行业专家库-专家行为浏览详细信息
     */
    @GetMapping(value = "/{fProBehInforId}")
    public AjaxResult getInfo(@PathVariable("fProBehInforId") Long fProBehInforId)
    {
        return AjaxResult.success(fProBehInforBrowseService.selectFProBehInforBrowseById(fProBehInforId));
    }

    /**
     * 新增行业专家库-专家行为浏览
     */
    @Log(title = "行业专家库-专家行为浏览", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FProBehInforBrowse fProBehInforBrowse)
    {
        return toAjax(fProBehInforBrowseService.insertFProBehInforBrowse(fProBehInforBrowse));
    }

    /**
     * 修改行业专家库-专家行为浏览
     */
    @Log(title = "行业专家库-专家行为浏览", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody FProBehInforBrowse fProBehInforBrowse)
    {
        return toAjax(fProBehInforBrowseService.updateFProBehInforBrowse(fProBehInforBrowse));
    }

    /**
     * 删除行业专家库-专家行为浏览
     */
    @Log(title = "行业专家库-专家行为浏览", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fProBehInforIds}")
    public AjaxResult remove(@PathVariable Long[] fProBehInforIds)
    {
        return toAjax(fProBehInforBrowseService.deleteFProBehInforBrowseByIds(fProBehInforIds));
    }
}
