package com.zehong.web.controller.operationMonitor;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.*;
import com.zehong.system.service.ISysPostService;
import com.zehong.system.service.ITHiddenTroubleInfoService;
import com.zehong.system.service.ITSupervisorInfoService;
import com.zehong.system.service.ITWorkOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;
import java.util.Map;

/**
 * 燃气任务Controller
 *
 * @author zehong
 * @date 2022-02-10
 */
@RestController
@RequestMapping("/system/order")
public class TWorkOrderController extends BaseController
{
    @Autowired
    private ITWorkOrderService tWorkOrderService;

    @Autowired
    private ISysPostService iSysPostService;

    @Autowired
    private ITHiddenTroubleInfoService troubleInfoService;

    @Autowired
    private ITSupervisorInfoService itSupervisorInfoService;

    @Autowired
    private TokenService tokenService;

    /**
     * 查询燃气任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkOrder tWorkOrder)
    {
        startPage();
        judgeUserRole(tWorkOrder);
        List<TWorkOrder> list = tWorkOrderService.selectTWorkOrderList(tWorkOrder);
        if(null != tWorkOrder.getWorkAssignEnterproseId()){
            for(TWorkOrder order : list){
                TSupervisorInfo tSupervisorInfo = new TSupervisorInfo();
                tSupervisorInfo.setWorkId(order.getWorkId());
                List<TSupervisorInfo> supervisorInfos = itSupervisorInfoService.selectTSupervisorInfoList(tSupervisorInfo);
                if(null != supervisorInfos && supervisorInfos.size()>0){
                    order.setSupervisorInfoList(supervisorInfos);
                }
            }
        }
        return getDataTable(list);
    }
    @GetMapping("/listCount")
    public AjaxResult listCount(TWorkOrder tWorkOrder)
    {
        judgeUserRole(tWorkOrder);
        List<Map<String,Object>> list = tWorkOrderService.selectTWorkOrderListCount(tWorkOrder);
        return AjaxResult.success(list);
    }
    /**
     * 导出燃气任务列表
     */
    @Log(title = "燃气任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkOrder tWorkOrder)
    {
        judgeUserRole(tWorkOrder);
        List<TWorkOrder> list = tWorkOrderService.selectTWorkOrderList(tWorkOrder);
        ExcelUtil<TWorkOrder> util = new ExcelUtil<TWorkOrder>(TWorkOrder.class);
        return util.exportExcel(list, "燃气任务数据");
    }

    /**
     * 判断用户角色
     * @param tWorkOrder
     */
    private void judgeUserRole(TWorkOrder tWorkOrder){
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取用户所属单位
        String enterpriseId = user.getDeptId();
        //判断是否为政府用户
        if(!"-2".equals(String.valueOf(enterpriseId))){
            tWorkOrder.setWorkAssignEnterproseId(enterpriseId);
            //判断是否为巡线员
            List<Integer> postIds = iSysPostService.selectPostListByUserId(user.getUserId());
            for(Integer postId : postIds){
                SysPost postInfo = iSysPostService.selectPostById(postId.longValue());
                if("se".equals(postInfo.getPostCode()) && postIds.size()==1){
                    tWorkOrder.setWorkAssignManId(user.getUserId());
                }
            }
        }
    }

    /**
     * 获取燃气任务详细信息
     */
    @GetMapping(value = "/{workId}")
    public AjaxResult getInfo(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tWorkOrderService.selectTWorkOrderById(workId));
    }

    /**
     * 新增燃气任务
     */
    @Log(title = "燃气任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkOrder tWorkOrder)
    {
        return toAjax(tWorkOrderService.insertTWorkOrder(tWorkOrder));
    }
    @PostMapping("/location")
    public AjaxResult insertsLocations(@RequestParam String locations)
    {

        return toAjax(tWorkOrderService.insertsLocations(locations));
    }

    @PostMapping("/location2")
    public AjaxResult insertsLocations2(@RequestBody TUserLocation location)
    {

        return toAjax(tWorkOrderService.insertsLocation(location));
    }
    /**
     * 修改燃气任务
     */
    @Log(title = "燃气任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkOrder tWorkOrder)
    {
        int edit = tWorkOrderService.updateTWorkOrder(tWorkOrder);
        if(1 == edit && null != tWorkOrder.getHiddenList() && !tWorkOrder.getHiddenList().isEmpty()){
            for(THiddenTroubleInfo tHiddenTroubleInfo : tWorkOrder.getHiddenList()){
                troubleInfoService.insertTHiddenTroubleInfo(tHiddenTroubleInfo);
            }
        }
        return AjaxResult.success();
    }

    /**
     * 删除燃气任务
     */
    @Log(title = "燃气任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workIds}")
    public AjaxResult remove(@PathVariable Long[] workIds)
    {
        return toAjax(tWorkOrderService.deleteTWorkOrderByIds(workIds));
    }

    @GetMapping("/selectWorkOrderNum")
    public AjaxResult selectWorkOrderNum(String enterpriseId)
    {
        /**
         * 判断是否是政府单位登录 如果不是 就只查询出本企业下面的数据
         */
        //获取当前登录用户信息
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        if ("-2".equals(user.getDeptId())){
//            user.setDeptId((long) 0);
        }else {
            enterpriseId= String.valueOf(user.getDeptId());
        }
        Map<String, Object> stringObjectMap = tWorkOrderService.selectWorkOrderNum(enterpriseId);
        return  AjaxResult.success(stringObjectMap);
    }

}
