package com.zehong.web.controller.message;

import java.util.List;

import com.zehong.system.domain.TMessageDetailInfo;
import com.zehong.system.service.ITMessageDetailInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMessageInfo;
import com.zehong.system.service.ITMessageInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 消息Controller
 * 
 * @author zehong
 * @date 2023-09-14
 */
@RestController
@RequestMapping("/message/info")
public class TMessageInfoController extends BaseController
{
    @Autowired
    private ITMessageInfoService tMessageInfoService;

    @Autowired
    private ITMessageDetailInfoService itMessageDetailInfoService;

    /**
     * 查询消息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TMessageInfo tMessageInfo)
    {
        startPage();
        List<TMessageInfo> list = tMessageInfoService.selectTMessageInfoList(tMessageInfo);
        for(TMessageInfo messageInfo : list){
            TMessageDetailInfo detailInfo = new TMessageDetailInfo();
            detailInfo.setMessageId(messageInfo.getMessageId());
            List<TMessageDetailInfo> detailInfoList = itMessageDetailInfoService.selectTMessageDetailInfoList(detailInfo);
            messageInfo.setMessageDetailInfoList(detailInfoList);
        }
        return getDataTable(list);
    }

    /**
     * 小程序通知消息
     * @param tMessageInfo
     * @return
     */
    @GetMapping("/applist")
    public TableDataInfo applist(TMessageInfo tMessageInfo)
    {
        startPage();
        List<TMessageInfo> list = tMessageInfoService.selectTMessageInfoListapp(tMessageInfo);
        return getDataTable(list);
    }
    /**
     * 导出消息列表
     */
    @Log(title = "消息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMessageInfo tMessageInfo)
    {
        List<TMessageInfo> list = tMessageInfoService.selectTMessageInfoList(tMessageInfo);
        ExcelUtil<TMessageInfo> util = new ExcelUtil<TMessageInfo>(TMessageInfo.class);
        return util.exportExcel(list, "消息数据");
    }

    /**
     * 获取消息详细信息
     */
    @GetMapping(value = "/{messageId}")
    public AjaxResult getInfo(@PathVariable("messageId") Long messageId)
    {
        TMessageInfo messageInfo = tMessageInfoService.selectTMessageInfoById(messageId);
        TMessageDetailInfo detailInfo = new TMessageDetailInfo();
        detailInfo.setMessageId(messageInfo.getMessageId());
        List<TMessageDetailInfo> detailInfoList = itMessageDetailInfoService.selectTMessageDetailInfoList(detailInfo);
        messageInfo.setMessageDetailInfoList(detailInfoList);
        return AjaxResult.success(messageInfo);
    }

    /**
     * 新增消息
     */
    @Log(title = "消息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMessageInfo tMessageInfo)
    {
        return toAjax(tMessageInfoService.insertTMessageInfo(tMessageInfo));
    }

    /**
     * 修改消息
     */
    @Log(title = "消息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMessageInfo tMessageInfo)
    {
        return toAjax(tMessageInfoService.updateTMessageInfo(tMessageInfo));
    }

    /**
     * 删除消息
     */
    @Log(title = "消息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{messageIds}")
    public AjaxResult remove(@PathVariable Long[] messageIds)
    {
        return toAjax(tMessageInfoService.deleteTMessageInfoByIds(messageIds));
    }
}
