package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.*;
import com.zehong.system.domain.vo.AirChargeStatisticsVo;
import com.zehong.system.service.ITAirChargeRecordService;
import com.zehong.system.service.ITGasBottleInfoService;
import com.zehong.system.service.ITGasBottleTrackRecordService;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 充装记录Controller
 *
 * @author zehong
 * @date 2023-08-21
 */
@RestController
@RequestMapping("/charge/record")
public class TAirChargeRecordController extends BaseController
{
    @Autowired
    private ITAirChargeRecordService tAirChargeRecordService;

    @Autowired
    private ITGasBottleInfoService tGasBottleInfoService;

    @Autowired
    private ITGasBottleTrackRecordService tGasBottleTrackRecordService;

    @Autowired
    private ITTaskRecordService tTaskRecordService;


    /**
     * 查询充装记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TAirChargeRecord tAirChargeRecord)
    {
        startPage();
        List<TAirChargeRecord> list = tAirChargeRecordService.selectTAirChargeRecordList(tAirChargeRecord);
        return getDataTable(list);
    }

    /**
     * 导出充装记录列表
     */
    @Log(title = "充装记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TAirChargeRecord tAirChargeRecord)
    {
        List<TAirChargeRecord> list = tAirChargeRecordService.selectTAirChargeRecordList(tAirChargeRecord);
        ExcelUtil<TAirChargeRecord> util = new ExcelUtil<TAirChargeRecord>(TAirChargeRecord.class);
        return util.exportExcel(list, "充装记录数据");
    }

    /**
     * 获取充装记录详细信息
     */
    @GetMapping(value = "/{chargeRecordId}")
    public AjaxResult getInfo(@PathVariable("chargeRecordId") Long chargeRecordId)
    {
        return AjaxResult.success(tAirChargeRecordService.selectTAirChargeRecordById(chargeRecordId));
    }

    /**
     * 微信小程序 首页列表查询接口
     * @param chargeRecordId
     * @return
     */
    @GetMapping("/selectGetInfo")
    public AjaxResult selectGetInfo(Long chargeRecordId){
        TAirChargeRecord tAirChargeRecord = tAirChargeRecordService.selectTAirChargeRecordById(chargeRecordId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tAirChargeRecord", tAirChargeRecord);
        return ajax;
    }

    /**
     * 新增充装记录
     */
    @Log(title = "充装记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TAirChargeRecord tAirChargeRecord)
    {
        return toAjax(tAirChargeRecordService.insertTAirChargeRecord(tAirChargeRecord));
    }

    /**
     * 小程序充装记录
     * @param tAirChargeRecord
     * @return
     */
    @PostMapping("/addAirChargeRecord")
    public AjaxResult addAirChargeRecord(@RequestBody TAirChargeRecord tAirChargeRecord) throws ParseException {
        TGasBottleInfo tGasBottleInfo=new TGasBottleInfo();
        tGasBottleInfo.setBottleId(tAirChargeRecord.getBottleId());
        //修改气瓶状态为满瓶
        tGasBottleInfo.setEmptyType("1");
        //修改气瓶信息
        tGasBottleInfoService.updateTGasBottleInfo(tGasBottleInfo);
//        DateFormat fmt =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        Date date = fmt.parse(tAirChargeRecord.getChargeDates());
        tAirChargeRecord.setChargeDate(new Date());
        //气瓶追溯信息添加
        TGasBottleTrackRecord tGasBottleTrackRecord=new TGasBottleTrackRecord();
        //储配站主键
        tGasBottleTrackRecord.setStationId(tAirChargeRecord.getStationId());
        //储配站
        tGasBottleTrackRecord.setStationName(tAirChargeRecord.getStationName());
        //气瓶主键
        tGasBottleTrackRecord.setBottleId(tAirChargeRecord.getBottleId());
        //气瓶条码
        tGasBottleTrackRecord.setBottleCode(tAirChargeRecord.getBottleCode());
        //工序 气瓶充装
        tGasBottleTrackRecord.setProcessesName("0");
        //充装人员
        tGasBottleTrackRecord.setOperator(tAirChargeRecord.getChargeOperator());
        tGasBottleTrackRecord.setOperateDate(new Date());

        //充装表信息添加
        tAirChargeRecordService.insertTAirChargeRecord(tAirChargeRecord);
        //气瓶追溯表信息添加
        tGasBottleTrackRecord.setProcessesRelationId(tAirChargeRecord.getChargeRecordId());
        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(tAirChargeRecord.getChargeOperator());
        //工序
        tTaskRecord.setProcessesName("0");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tAirChargeRecord.getChargeRecordId());
        //任务记录表信息添加
        tTaskRecordService.insertTTaskRecord(tTaskRecord);
        return toAjax( tGasBottleTrackRecordService.insertTGasBottleTrackRecord(tGasBottleTrackRecord));
    }

    /**
     * 修改充装记录
     */
    @Log(title = "充装记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TAirChargeRecord tAirChargeRecord)
    {
        return toAjax(tAirChargeRecordService.updateTAirChargeRecord(tAirChargeRecord));
    }

    /**
     * 删除充装记录
     */
    @Log(title = "充装记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{chargeRecordIds}")
    public AjaxResult remove(@PathVariable Long[] chargeRecordIds)
    {
        return toAjax(tAirChargeRecordService.deleteTAirChargeRecordByIds(chargeRecordIds));
    }

    /**
     * 充装记录导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @Log(title = "充装记录导入", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TAirChargeRecord> util = new ExcelUtil<>(TAirChargeRecord.class);
        List<TAirChargeRecord> airChargeRecordList = util.importExcel(file.getInputStream());
        String message = tAirChargeRecordService.importAirChargeRecordInfo(airChargeRecordList, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TAirChargeRecord> util = new ExcelUtil<>(TAirChargeRecord.class);
        return util.importTemplateExcel("充装记录数据");
    }

    /**
     * 储配站充装统计
     * @param airChargeStatisticsVo 统计实体
     * @return
     */
    @GetMapping("/airChargeStationStatistics")
    public TableDataInfo airChargeStationStatistics(AirChargeStatisticsVo airChargeStatisticsVo){
        startPage();
        return getDataTable(tAirChargeRecordService.airChargeStationStatistics(airChargeStatisticsVo));
    }

    @GetMapping("/airChargeStationStatisticExport")
    public AjaxResult airChargeStationStatisticExport(AirChargeStatisticsVo airChargeStatisticsVo){
        List<AirChargeStationStatistics> list = tAirChargeRecordService.airChargeStationStatistics(airChargeStatisticsVo);
        ExcelUtil<AirChargeStationStatistics> util = new ExcelUtil<>(AirChargeStationStatistics.class);
        return util.exportExcel(list, "充装统计数据");
    }

    /**
     * 充装人员统计
     * @param airChargeStatisticsVo 统计
     * @return
     */
    @GetMapping("/airChargeOperatorStatistics")
    public TableDataInfo airChargeOperatorStatistics(AirChargeStatisticsVo airChargeStatisticsVo){
        startPage();
        return getDataTable(tAirChargeRecordService.airChargeOperatorStatistics(airChargeStatisticsVo));
    }

    @GetMapping("/airChargeOperatorStatisticsExport")
    public AjaxResult airChargeOperatorStatisticsExport(AirChargeStatisticsVo airChargeStatisticsVo){
        List<AirChargeOperatorStatistics> list = tAirChargeRecordService.airChargeOperatorStatistics(airChargeStatisticsVo);
        ExcelUtil<AirChargeOperatorStatistics> util = new ExcelUtil<>(AirChargeOperatorStatistics.class);
        return util.exportExcel(list, "充装统计数据");
    }
}
