package com.zehong.web.controller.energency;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyDrills;
import com.zehong.system.service.ITEmergencyDrillsService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急演练Controller
 * 
 * @author zehong
 * @date 2024-04-19
 */
@RestController
@RequestMapping("/emergencydrills/record")
public class TEmergencyDrillsController extends BaseController
{
    @Autowired
    private ITEmergencyDrillsService tEmergencyDrillsService;

    /**
     * 查询应急演练列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyDrills tEmergencyDrills)
    {
        startPage();
        List<TEmergencyDrills> list = tEmergencyDrillsService.selectTEmergencyDrillsList(tEmergencyDrills);
        return getDataTable(list);
    }

    /**
     * 导出应急演练列表
     */
    @Log(title = "应急演练", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyDrills tEmergencyDrills)
    {
        List<TEmergencyDrills> list = tEmergencyDrillsService.selectTEmergencyDrillsList(tEmergencyDrills);
        ExcelUtil<TEmergencyDrills> util = new ExcelUtil<TEmergencyDrills>(TEmergencyDrills.class);
        return util.exportExcel(list, "应急演练数据");
    }

    /**
     * 获取应急演练详细信息
     */
    @GetMapping(value = "/getDetail/{fDrillsId}")
    public AjaxResult getInfo(@PathVariable("fDrillsId") Long fDrillsId)
    {
        return AjaxResult.success(tEmergencyDrillsService.selectTEmergencyDrillsById(fDrillsId));
    }

    /**
     * 新增应急演练
     */
    @Log(title = "应急演练", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyDrills tEmergencyDrills)
    {
        return toAjax(tEmergencyDrillsService.insertTEmergencyDrills(tEmergencyDrills));
    }

    /**
     * 修改应急演练
     */
    @Log(title = "应急演练", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyDrills tEmergencyDrills)
    {
        return toAjax(tEmergencyDrillsService.updateTEmergencyDrills(tEmergencyDrills));
    }

    /**
     * 删除应急演练
     */
    @Log(title = "应急演练", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fDrillsIds}")
    public AjaxResult remove(@PathVariable Long[] fDrillsIds)
    {
        return toAjax(tEmergencyDrillsService.deleteTEmergencyDrillsByIds(fDrillsIds));
    }
}
