package com.zehong.web.controller.decrypt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zehong.system.domain.*;
import com.zehong.system.service.DecryptService;
import com.zehong.web.controller.tool.DESEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 企业信息解密控制层
 */
@RestController
@RequestMapping("/api")
public class DecryptController {


    @Autowired
    DecryptService decryptService;



    @PostMapping("/dataDecryption")
    public void dataDecryption(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        if (selectkey!=null){

            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());

            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("events");

            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            System.out.println(list);
            for (int i=0;i<list.size();i++){
              System.out.println(list.get(i));
                JSONObject jsonObject = list.get(i);
                jsonObject.getString("avx");
                System.out.println( jsonObject.getString("avx"));
            }

//            ArrayList<Pisnt> list=new ArrayList<>();
//            Pisnt pisnt1 = JSONObject.parseObject(oname1, Pisnt.class);
//            System.out.println(pisnt1);
//            Pisnt pisnt=new Pisnt();
        }
    }


    /**
     * 巡检巡查计划
     * @param encryption
     */
    @PostMapping("/inspectionWorkPlan")
    public void inspectionWorkPlan(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<InspectionWorkPlan> InspectionWorkPlanList=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                InspectionWorkPlan inspectionWorkPlan=new InspectionWorkPlan();
                JSONObject jsonObject = list.get(i);
                inspectionWorkPlan.setPno(jsonObject.getString("pno"));
                inspectionWorkPlan.setPcontent(jsonObject.getString("pcontent"));
                inspectionWorkPlan.setPname(jsonObject.getString("pname"));
                inspectionWorkPlan.setPremark(jsonObject.getString("premark"));
                inspectionWorkPlan.setPtimebegin(jsonObject.getString("ptimebegin"));
                inspectionWorkPlan.setPtimeend(jsonObject.getString("ptimeend"));
                inspectionWorkPlan.setPtype(jsonObject.getString("ptype"));
                inspectionWorkPlan.setPyear(jsonObject.getString("pyear"));
                InspectionWorkPlanList.add(inspectionWorkPlan);
            }
        }
        System.out.println("报警器传输"+InspectionWorkPlanList);
    }



    @PostMapping("/inspectionWork")
    public void inspectionWork(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<InspectionWork> inspectionWorkList=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                InspectionWork inspectionwork=new InspectionWork();
                JSONObject jsonObject = list.get(i);
                inspectionwork.setWno(jsonObject.getString("wno"));
                inspectionwork.setWname(jsonObject.getString("wname"));
                inspectionwork.setWtype(jsonObject.getString("wtype"));
                inspectionwork.setWcreatetime(jsonObject.getString("wcreatetime"));
                inspectionwork.setWendtime(jsonObject.getString("wendtime"));
                inspectionwork.setWcontent(jsonObject.getString("wcontent"));
                inspectionwork.setWinspector(jsonObject.getString("winspector"));
                inspectionwork.setWfeedbackinfo(jsonObject.getString("wfeedbackinfo"));
                inspectionwork.setWfeedbacktime(jsonObject.getString("wfeedbacktime"));
                inspectionwork.setWfeedbackimg(jsonObject.getString("wfeedbackimg"));
                inspectionwork.setWremark(jsonObject.getString("wremark"));
                inspectionWorkList.add(inspectionwork);
            }
        }
        System.out.println("报警器传输"+inspectionWorkList);
    }


    @PostMapping("/construction")
    public void construction(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<Construction> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                Construction construction=new Construction();
                JSONObject jsonObject = list.get(i);
                construction.setBh(jsonObject.getString("bh"));
                construction.setBz(jsonObject.getString("bz"));
                construction.setSgdw(jsonObject.getString("sgdw"));
                construction.setBasj(jsonObject.getString("basj"));
                construction.setSgksrq(jsonObject.getString("sgksrq"));
                construction.setSgjsrq(jsonObject.getString("sgjsrq"));
                construction.setSgms(jsonObject.getString("sgms"));
                construction.setZt(jsonObject.getString("zt"));
                List.add(construction);
            }
        }
        System.out.println("报警器传输"+List);
    }


    @PostMapping("/devicedata")
    public void devicedata(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<SafetyData> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                SafetyData json=new SafetyData();
                JSONObject jsonObject = list.get(i);
                json.setSbbh(jsonObject.getString("sbbh"));
                json.setSblx(jsonObject.getString("sblx"));
                json.setCjsj(jsonObject.getString("cjsj"));
                json.setZt(jsonObject.getString("zt"));
                json.setYl(jsonObject.getString("yl"));
                json.setWd(jsonObject.getString("wd"));
                json.setBkljl(jsonObject.getString("bkljl"));
                json.setGkljl(jsonObject.getString("gkljl"));
                json.setNxbkljl(jsonObject.getString("nxbkljl"));
                json.setSyl(jsonObject.getString("syl"));
                json.setBkll(jsonObject.getString("bkll"));
                json.setGkll(jsonObject.getString("gkll"));
                json.setNd(jsonObject.getString("nd"));
                List.add(json);
            }
        }
        System.out.println("报警器传输"+List);
    }


    @PostMapping("/devicealarm")
    public void Devicealarm(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<Devicealarm> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                Devicealarm json=new Devicealarm();
                JSONObject jsonObject = list.get(i);
                json.setSbbh(jsonObject.getString("sbbh"));
                json.setSblx(jsonObject.getString("sblx"));
                json.setCjsj(jsonObject.getString("cjsj"));
                json.setZt(jsonObject.getString("zt"));
                json.setZt(jsonObject.getString("bjz"));
                List.add(json);
            }
        }
        System.out.println("报警器传输"+List);
    }



    @PostMapping("/vehicle")
    public void Vehicle(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<Vehicle> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                Vehicle json=new Vehicle();
                JSONObject jsonObject = list.get(i);
                json.setCph(jsonObject.getString("sbbh"));
                json.setCjsj(jsonObject.getString("cjsj"));
                json.setJd(jsonObject.getString("zt"));
                json.setWd(jsonObject.getString("bjz"));
                List.add(json);
            }
        }
        System.out.println("报警器传输"+List);
    }


    @PostMapping("/gascylinder")
    public void gascylinder(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<Gascylinder> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                Gascylinder json=new Gascylinder();
                JSONObject jsonObject = list.get(i);
                json.setQpbh(jsonObject.getString("qpbh"));
                json.setCjsj(jsonObject.getString("cjsj"));
                json.setJd(jsonObject.getString("zt"));
                json.setWd(jsonObject.getString("bjz"));
                List.add(json);
            }
        }
        System.out.println("报警器传输"+List);
    }


    @PostMapping("/hiddendanger")
    public void hiddendanger(@RequestBody Encryption encryption){
        DESEncoder desEncoder=new DESEncoder();
        //获取企业解密数据秘钥
        keyInformation selectkey = decryptService.selectkey(encryption.getQybm());
        List<Hiddendanger> List=new ArrayList<>();
        if (selectkey!=null){
            //传入数据 解密
            String decrypt = desEncoder.decrypt(encryption.getData(), selectkey.getSecretKey());
            JSONObject jsonObject1 = JSON.parseObject(decrypt.toString());
            String oname1 = jsonObject1.getString("rts");
            JSONArray jsonArray = JSON.parseArray(oname1);
            String js=JSONObject.toJSONString(jsonArray, SerializerFeature.WriteClassName);
            List<JSONObject> list = JSONObject.parseArray(js,JSONObject.class);
            //循环数组
            for (int i=0;i<list.size();i++){
                Hiddendanger json=new Hiddendanger();
                JSONObject jsonObject = list.get(i);
                json.setYhbh(jsonObject.getString("yhbh"));
                json.setYhmc(jsonObject.getString("yhmc"));
                json.setYhdj(jsonObject.getString("yhdj"));
                json.setYhnr(jsonObject.getString("yhnr"));
                json.setJd(jsonObject.getString("jd"));
                json.setWd(jsonObject.getString("wd"));
                json.setFxry(jsonObject.getString("fxry"));
                json.setFxsj(jsonObject.getString("fxsj"));
                json.setZzqk(jsonObject.getString("zzqk"));
                json.setBz(jsonObject.getString("bz"));
                List.add(json);
            }
        }
        System.out.println("报警器传输"+List);
    }


}
