package com.zehong.web.controller.complainDeal;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.TComplainDealOverSuper;
import com.zehong.system.service.ITComplainDealOverSuperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 燃气投诉处置-超时督办Controller
 * 
 * @author zehong
 * @date 2024-06-13
 */
@RestController
@RequestMapping("/complainDeal/super")
public class TComplainDealOverSuperController extends BaseController
{
    @Autowired
    private ITComplainDealOverSuperService tComplainDealOverSuperService;

    @Autowired
    private TokenService tokenService;
    /**
     * 查询燃气投诉处置-超时督办列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TComplainDealOverSuper tComplainDealOverSuper)
    {
        startPage();
        List<TComplainDealOverSuper> list = tComplainDealOverSuperService.selectTComplainDealOverSuperList(tComplainDealOverSuper);
        return getDataTable(list);
    }

    /**
     * 导出燃气投诉处置-超时督办列表
     */
    @Log(title = "燃气投诉处置-超时督办", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TComplainDealOverSuper tComplainDealOverSuper)
    {
        List<TComplainDealOverSuper> list = tComplainDealOverSuperService.selectTComplainDealOverSuperList(tComplainDealOverSuper);
        ExcelUtil<TComplainDealOverSuper> util = new ExcelUtil<TComplainDealOverSuper>(TComplainDealOverSuper.class);
        return util.exportExcel(list, "燃气投诉处置-超时督办数据");
    }

    /**
     * 获取燃气投诉处置-超时督办详细信息
     */
    @GetMapping(value = "/{complainDealOverSuperId}")
    public AjaxResult getInfo(@PathVariable("complainDealOverSuperId") Long complainDealOverSuperId)
    {
        return AjaxResult.success(tComplainDealOverSuperService.selectTComplainDealOverSuperById(complainDealOverSuperId));
    }

    /**
     * 新增燃气投诉处置-超时督办
     */
    @Log(title = "燃气投诉处置-超时督办", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TComplainDealOverSuper tComplainDealOverSuper)
    {
        return toAjax(tComplainDealOverSuperService.insertTComplainDealOverSuper(tComplainDealOverSuper));
    }

    /**
     * 修改燃气投诉处置-超时督办
     */
    @Log(title = "燃气投诉处置-超时督办", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TComplainDealOverSuper tComplainDealOverSuper)
    {

        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        //说明是企业反馈了
        if (!"-2".equals(user.getDeptId())) {
            tComplainDealOverSuper.setOvertimeSupervision("1");
        }

        return toAjax(tComplainDealOverSuperService.updateTComplainDealOverSuper(tComplainDealOverSuper));
    }

    /**
     * 删除燃气投诉处置-超时督办
     */
    @Log(title = "燃气投诉处置-超时督办", businessType = BusinessType.DELETE)
	@DeleteMapping("/{complainDealOverSuperIds}")
    public AjaxResult remove(@PathVariable Long[] complainDealOverSuperIds)
    {
        return toAjax(tComplainDealOverSuperService.deleteTComplainDealOverSuperByIds(complainDealOverSuperIds));
    }


    /**
     * 查询燃气投诉处置-超时督办列表-根据处置id 和 状态
     */
    @GetMapping("/getOverSuperByComplainDealIdAndStatus")
    public AjaxResult getOverSuperByComplainDealIdAndStatus(TComplainDealOverSuper tComplainDealOverSuper) {
        return AjaxResult.success(tComplainDealOverSuperService.getOverSuperByComplainDealIdAndStatus(tComplainDealOverSuper));
    }

    /**
     *
     * 超时督办确认反馈
     * @param tComplainDealOverSuper t
     * @return a
     */
    @PostMapping("/overtimeSupervisionFeedbackConfirmation")
    public AjaxResult overtimeSupervisionFeedbackConfirmation(@RequestBody TComplainDealOverSuper tComplainDealOverSuper){
        return toAjax(tComplainDealOverSuperService.overtimeSupervisionFeedbackConfirmation(tComplainDealOverSuper));
    }
}
