/*
 * @Author: 纪泽龙 jizelong@qq.com
 * @Date: 2024-07-30 15:09:53
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @LastEditTime: 2024-08-02 14:08:42
 * @FilePath: /zh-baseversion-web/src/utils/mapClass/mapLoca.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { pipeColor, svgUrl, svgAlarm } from "@/utils/mapClass/config.js";

export class LocalLine {
  loca = null;
  layerCompanyArr = {};
  layer = null;
  geo = null;
  headColors = [
    "#179CB7",
    "#20B156",
    "#FF9939",
    "#FF0000",
    "#E06AC4",
    "#223F9B",
    "#F15C1A",
    "#7A0FA6",
  ];
  constructor(map, geoJsonArr) {
    // return;

    this.loca = new Loca.Container({
      map,
    });
    // return this.loca;
  }
  init(geoJsonArr) {
    geoJsonArr.forEach((item) => {
      let layer = new Loca.PulseLineLayer({
        // loca,
        zIndex: 10,
        opacity: 1,
        visible: true,
        zooms: [2, 22],
      });
      layer.d = item.d;
      if (!this.layerCompanyArr[item.d.iconType]) {
        this.layerCompanyArr[item.d.iconType] = [];
      }
      this.layerCompanyArr[item.d.iconType].push(layer);

      const geo = new Loca.GeoJSONSource({
        data: item,
      });

      layer.setSource(geo);

      layer.setStyle({
        altitude: 0,
        lineWidth: 3,
        // 脉冲头颜色
        headColor: (_, feature) => {
          return this.headColors[feature.properties.type - 1];
        },
        // 脉冲尾颜色
        trailColor: "rgba(128, 128, 128, 0.5)",
        // 脉冲长度，0.25 表示一段脉冲占整条路的 1/4
        interval: 0.25,
        // 脉冲线的速度，几秒钟跑完整段路
        duration: 5000,
      });
      // console.log('this.loca.add', this.layer)

      this.loca.add(layer);
      this.start();
    });
  }
  show() {
    // this.layer.show();
  }
  hide() {
    // this.layer.hids();
  }

  allfilter(companyArr, typeArr) {
    for (let pipeItem in this.layerCompanyArr) {
      this.layerCompanyArr[pipeItem].forEach((pipe) => {
        const data = pipe.d;
        if (
          companyArr.indexOf(data.companyType + "") >= 0 &&
          typeArr.indexOf(1) >= 0
        ) {
          pipe.show();
        } else {
          pipe.hide();
        }
      });
    }
  }
  stop() {
    this.loca.animate.stop();

  }
  start() {
    this.loca.animate.start();
  }
}
