import request from '@/utils/request'

// 查询第三方施工-涉气第三方施工项目档案列表
export function listInfor(query) {
  return request({
    url: '/third/project/list',
    method: 'get',
    params: query
  })
}

// 查询第三方施工-涉气第三方施工项目档案详细
export function getInfor(fConGasProInforId) {
  return request({
    url: '/third/project/' + fConGasProInforId,
    method: 'get'
  })
}

// 新增第三方施工-涉气第三方施工项目档案
export function addInfor(data) {
  return request({
    url: '/third/project',
    method: 'post',
    data: data
  })
}

// 修改第三方施工-涉气第三方施工项目档案
export function updateInfor(data) {
  return request({
    url: '/third/project',
    method: 'put',
    data: data
  })
}

// 删除第三方施工-涉气第三方施工项目档案
export function delInfor(fConGasProInforId) {
  return request({
    url: '/third/project/' + fConGasProInforId,
    method: 'delete'
  })
}

// 导出第三方施工-涉气第三方施工项目档案
export function exportInfor(query) {
  return request({
    url: '/third/project/export',
    method: 'get',
    params: query
  })
}

export function reportConGasProInfo(query) {
  return request({
    url: '/third/project/reportConGasProInfo',
    method: 'get',
    params: query
  })
}


export function entReportConGasProInfo(query) {
  return request({
    url: '/third/project/entReportConGasProInfo',
    method: 'get',
    params: query
  })
}

export function conGasProInfoList(query) {
  return request({
    url: '/third/project/conGasProInfoList',
    method: 'get',
    params: query
  })
}
