import request from '@/utils/request'

// 查询监督检查列表
export function listSupervise(query) {
  return request({
    url: '/system/supervise/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查详细
export function getSupervise(id) {
  return request({
    url: '/system/supervise/' + id,
    method: 'get'
  })
}

// 新增监督检查
export function addSupervise(data) {
  return request({
    url: '/system/supervise',
    method: 'post',
    data: data
  })
}

// 修改监督检查
export function updateSupervise(data) {
  return request({
    url: '/system/supervise',
    method: 'put',
    data: data
  })
}

// 删除监督检查
export function delSupervise(id) {
  return request({
    url: '/system/supervise/' + id,
    method: 'delete'
  })
}

// 导出监督检查
export function exportSupervise(query) {
  return request({
    url: '/system/supervise/export',
    method: 'get',
    params: query
  })
}